% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coin_treat.R
\name{BoxCox}
\alias{BoxCox}
\title{Box Cox transformation}
\usage{
BoxCox(x, lambda, makepos = TRUE)
}
\arguments{
\item{x}{A vector or column of data to transform}

\item{lambda}{The lambda parameter of the Box Cox transform}

\item{makepos}{If \code{TRUE} (default) makes all values positive by subtracting the minimum and adding 1.}
}
\value{
A vector of length \code{length(x)} with transformed values.
}
\description{
Simple Box Cox, with no optimisation of lambda.
See \href{https://bluefoxr.github.io/COINrDoc/data-treatment.html#transformation}{COINr online documentation} for more details.
}
\examples{
# get a column of data with outliers
x <- ASEMIndData$Tariff
# Apply Box Cox
xBox <- BoxCox(x, lambda = 2)
# plot one against the other
plot(x, xBox)

}
\seealso{
\itemize{
\item \code{\link[=treat]{treat()}} Outlier treatment
}
}
