% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coin_resultsdash.R
\name{iplotBar}
\alias{iplotBar}
\title{Bar chart}
\usage{
iplotBar(
  COIN,
  dset = "Raw",
  isel = NULL,
  usel = NULL,
  aglev = NULL,
  stack_children = FALSE,
  from_group = NULL
)
}
\arguments{
\item{COIN}{The COIN object, or a data frame of indicator data.}

\item{dset}{The data set to plot.}

\item{isel}{The selected indicator code or aggregate (does not support multiple indicators)}

\item{usel}{A character vector of unit codes to highlight on the bar chart (optional)}

\item{aglev}{The aggregation level to collect the indicator data from (this needs to be specified)}

\item{stack_children}{If \code{TRUE}, produces a stacked bar chart with any children of \code{isel.} In this case, \code{usel} is ignored.
This only works if \code{dset = "Aggregated"} and \code{aglev > 1}.}

\item{from_group}{Filters the bar chart to a specified group using a group column that is present in the specified
data set. Specified as \code{list(group_variable = selected_group)}.}
}
\value{
Interactive bar chart generated by plotly.
}
\description{
Generates an interactive bar chart. This function is simply a wrapper for
the \strong{plotly} bar chart function, but accesses the COIN object to get the relevant indicator.
Also has click event data for Shiny. Allows construction of stacked bar charts which show underlying components (for aggregated
data only), and plots of only specified groups.
}
\examples{
# assemble ASEM COIN
ASEM <- assemble(IndData = ASEMIndData, IndMeta = ASEMIndMeta, AggMeta = ASEMAggMeta)
# plot Flights indicator
iplotBar(ASEM, dset = "Raw", isel = "Flights", aglev = 1)

}
\seealso{
\itemize{
\item \code{\link[=iplotMap]{iplotMap()}} bar chart of indicator or aggregate
\item \code{\link[=resultsDash]{resultsDash()}} interactive dashboard of indicator data
}
}
