% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coin_impute.R
\name{impute}
\alias{impute}
\title{Impute missing data}
\usage{
impute(
  COIN,
  imtype = NULL,
  dset = NULL,
  groupvar = NULL,
  EMaglev = NULL,
  out2 = "COIN"
)
}
\arguments{
\item{COIN}{A COIN or a data frame}

\item{imtype}{The type of imputation method. Either:
\itemize{
\item \code{"agg_mean"} (the mean of normalised indicators inside the aggregation group),
\item \code{"agg_median"} (the median of normalised indicators inside the aggregation group),
\item \code{"ind_mean"} (the mean of all the other units in the indicator),
\item \code{"ind_median"} (the median of all the other units in the indicator),
\item \code{"indgroup_mean"} (the mean of all the other units in the indicator, in the same group),
\item \code{"indgroup_median"} (the median of all the other units in the indicator, in the same group),
\item \code{"EM"} (expectation maximisation algorithm via AMELIA package, currently without bootstrapping)
\item \code{"none"} (no imputation, returns original data set)
}}

\item{dset}{The data set in \code{.$Data} to impute}

\item{groupvar}{The name of the column to use for by-group imputation. Only applies when \code{imtype} is set to a group option.}

\item{EMaglev}{The aggregation level to use if \code{imtype = "EM"}.}

\item{out2}{Where to output the imputed data frame. If \code{"COIN"} (default for COIN input), creates a new data set \code{.$Data$Imputed}.
Otherwise if \code{"df"} outputs directly to a data frame.}
}
\value{
If \code{out2 = "COIN"} (default for COIN input), creates a new data set \code{.$Data$Imputed}.
Otherwise if \code{out2 = "df"} outputs directly to a data frame.
}
\description{
Imputation of missing data data sets using a variety of methods (see \code{imtype}). This also includes the possibility of imputing
by grouping variables, i.e. columns of \code{IndData} that are prefaced by \code{"Group_"}.
}
\details{
See \href{https://bluefoxr.github.io/COINrDoc/missing-data-and-imputation.html#imputation-in-coinr}{online documentation} for further details and examples.
}
\examples{
# assemble the COIN
ASEM <- assemble(IndData = ASEMIndData, IndMeta = ASEMIndMeta, AggMeta = ASEMAggMeta)
# Check how many missing data points are in raw data set
sum(is.na(ASEM$Data$Raw))
# impute data using Asia/Europe group mean
DataImputed <- impute(ASEM, dset = "Raw", imtype = "indgroup_mean", groupvar = "Group_EurAsia",
out2 = "df")
# See how many missing data points we have in the imputed data
sum(is.na(DataImputed))
# check no missing data
stopifnot(sum(is.na(DataImputed))==0)

}
