% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_gen_p1.R
\name{data_gen_p1}
\alias{data_gen_p1}
\title{Data generation function for scenario 1}
\usage{
data_gen_p1(n = 11600, ratio = 3, all_confounder = FALSE)
}
\arguments{
\item{n}{total number of units for simulation}

\item{ratio}{ratio of units in the treatment groups}

\item{all_confounder}{TRUE or FALSE. overlap is lacking for a variable that is not predictive of the outcome (all_confounder equals to TRUE) or situations when it is lacking for a true confounder (all_confounder equals to FALSE)}
}
\value{
list with the 5 elements. Nested within each list, it contains
\item{n:}{Number of units for simulation}
\item{trt_ind:}{A data frame with number of rows equals to n and 11 columns}
\item{Y:}{Observed binary outcome for 3 treatments}
\item{Yobs:}{Observed binary outcome}
\item{Est:}{True ATE/ATT for RD/RR/OR}
}
\description{
This function generates data to test different causal inference methods for scenario 1.  Please use our main function data_gen.R
}
\examples{
library(CIMTx)
set.seed(3242019)
data_gen_p1(n = 116, ratio = 3,all_confounder=FALSE)
}
