% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/se_estimates_sandwich.R
\name{sandwich_se}
\alias{sandwich_se}
\title{Sandwich standard error estimates}
\usage{
sandwich_se(setting = "GLM", scores = NULL, hessian = NULL)
}
\arguments{
\item{setting}{String with value \code{"GLM"} or \code{"AFT"} indicating
whether standard error estimates are obtained for a
normally-distributed (\code{"GLM"}) or censored time-to-event
(\code{"AFT"}) primary outcome \code{Y}.}

\item{scores}{Score matrix of the parameters, which can be obtained using the
\code{\link{scores}} function.}

\item{hessian}{Hessian matrix of the parameters, which can be obtained using the
\code{\link{hessian}} function.}
}
\value{
Returns a vector with the CIEE sandwich standard error estimates
        of the parameter estimates.
}
\description{
Function to obtain consistent and robust sandwich standard error estimates
based on estimating equations, for the parameter estimates of the
\code{\link{get_estimates}} function, under the GLM or AFT setting
for the analysis of a normally-distributed or censored time-to-event primary
outcome.
}
\details{
Under the GLM setting for the analysis of a normally-distributed primary
outcome Y, robust sandwich standard error estimates are obtained for the
estimates of the parameters
\eqn{\alpha_0, \alpha_1, \alpha_2, \alpha_3, \sigma_1^2, \alpha_4, \alpha_{XY}, \sigma_2^2}{\alpha0, \alpha1, \alpha2, \alpha3, \sigma1^2, \alpha4, \alphaXY, \sigma2^2}
in the model
\deqn{Y = \alpha_0 + \alpha_1 \cdot K + \alpha_2 \cdot X + \alpha_3 \cdot L + \epsilon_1, \epsilon_1 \sim N(0,\sigma_1^2)}{Y = \alpha0 + \alpha1*K + \alpha2*X + \alpha3*L + \epsilon1, \epsilon1 ~ N(0,\sigma1^2)}
\deqn{Y^* = Y - \overline{Y} - \alpha_1 \cdot (K-\overline{K})}{Y* = Y - mean(Y) - \alpha1*(K-mean(K))}
\deqn{Y^* = \alpha_0 + \alpha_{XY} \cdot X + \epsilon_2, \epsilon_2 \sim N(0,\sigma_2^2)}{Y* = \alpha0 + \alphaXY*X + \epsilon2, \epsilon2 ~ N(0,\sigma2^2)}
by using the score and hessian matrices of the parameters.

Under the AFT setting for the analysis of a censored time-to-event primary
outcome, robust sandwich standard error estimates are  similarly obtained of
the parameter estimates of
\eqn{\alpha_0, \alpha_1, \alpha_2, \alpha_3, \sigma_1, \alpha_4, \alpha_{XY}, \sigma_2^2}{\alpha0, \alpha1, \alpha2, \alpha3, \sigma1, \alpha4, \alphaXY, \sigma2^2}.
For more details and the underlying model, see the vignette.
}
\examples{

# Generate data including Y, K, L, X under the GLM setting
dat <- generate_data(setting = "GLM")

# Obtain estimating functions expressions
estfunct <- est_funct_expr(setting = "GLM")

# Obtain point estimates of the parameters
estimates <- get_estimates(setting = "GLM", Y = dat$Y, X = dat$X,
                           K = dat$K, L = dat$L)

# Obtain matrices with all first and second derivatives
derivobj <- deriv_obj(setting = "GLM", logL1 = estfunct$logL1,
                      logL2 = estfunct$logL2, Y = dat$Y, X = dat$X,
                      K = dat$K, L = dat$L, estimates = estimates)

# Obtain score and hessian matrices
results_scores <- scores(derivobj)
results_hessian <- hessian(derivobj)

# Obtain sandwich standard error estimates of the parameters
sandwich_se(scores = results_scores, hessian = results_hessian)

}
