% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PostProcess.R
\name{suggestInitialLowerRange}
\alias{suggestInitialLowerRange}
\title{suggestInitialLowerRange}
\usage{
suggestInitialLowerRange(logLocation, alpha = 0.25, numBins = NA)
}
\arguments{
\item{logLocation}{(required input) \emph{A string or a list of strings} of folder directory where CGNM computation log files exist.}

\item{alpha}{(default: 0.25) \emph{a number between 0 and 1} level of significance used to derive the confidence interval.}

\item{numBins}{(default: NA) \emph{A positive integer} SSR surface is plotted by finding the minimum SSR given one of the parameters is fixed and then repeat this for various values.  numBins specifies the number of different parameter values to fix for each parameter. (if set NA the number of bins are set as num_minimizersToFind/10)}
}
\value{
\emph{A numerical vector} of suggested initial lower range based on profile likelihood.
}
\description{
Suggest initial lower range based on the profile likelihood. The user can re-run CGNM with this suggested initial range so that to improve the convergence.
}
\examples{
\dontrun{
model_analytic_function=function(x){

 observation_time=c(0.1,0.2,0.4,0.6,1,2,3,6,12)
 Dose=1000
 F=1

 ka=x[1]
 V1=x[2]
 CL_2=x[3]
 t=observation_time

 Cp=ka*F*Dose/(V1*(ka-CL_2/V1))*(exp(-CL_2/V1*t)-exp(-ka*t))

 log10(Cp)
}

observation=log10(c(4.91, 8.65, 12.4, 18.7, 24.3, 24.5, 18.4, 4.66, 0.238))

CGNM_result=Cluster_Gauss_Newton_method(
nonlinearFunction=model_analytic_function,
targetVector = observation,
initial_lowerRange = c(0.1,0.1,0.1), initial_upperRange =  c(10,10,10),
num_iter = 10, num_minimizersToFind = 100, saveLog=TRUE)

suggestInitialLowerRange("CGNM_log")
}
}
