% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CDFtestingSuite.R
\name{QuantileFromCDF}
\alias{QuantileFromCDF}
\title{Retrieve a private quantile estimate from the dpCDF}
\usage{
QuantileFromCDF(est, range, gran, quantile, ...)
}
\arguments{
\item{est}{The vector output of a differentially private CDF 
computation (cumulative count bins)}

\item{range}{A vector length 2 containing user-specified min and max to 
truncate the universe to}

\item{gran}{The smallest unit of measurement in the data (one [year] 
for a list of ages),
the Domain (ie gran and range) should be identical to those used to 
create the CDF!}

\item{quantile}{the quantile score in question (for testing the median,
use quantile = 0.5)}

\item{...}{Optionally add additional parameters. This is primarily used to allow automated
execution of varied diagnostic functions.}
}
\value{
A quantile value obtained from a (differentially private) CDF vector,
   not using any extra privacy budget
}
\description{
Determines a quantile value from a CDF vector.
}
\examples{
QuantileFromCDF(c(.1,.2,.3,.3,.3,.3,.3,.3,.4,1),c(1,10), 1, .05)
}

