/*
 * Decompiled with CFR 0.152.
 */
package org.neptuneinc.cadstat.plots;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.neptuneinc.cadstat.ui.DataPlotDialog;
import org.neptuneinc.cadstat.utils.GUIUtils;
import org.neptuneinc.cadstat.utils.RUtils;
import org.rosuda.JGR.JGR;
import org.rosuda.REngine.REXPMismatchException;
import org.rosuda.REngine.REngineException;

public class TraitInferences
extends DataPlotDialog {
    private JComboBox coefBioInferDataComboBox;
    private JLabel coefBioInferDataLabel;
    private JRadioButton coefBioInferDataRadioButton;
    private ButtonGroup coefDatabuttonGroup;
    private JPanel coefPane;
    private JPanel plotPane;
    private JLabel resultLabel;
    private JTextField resultName;
    private JPanel savePanel;
    private JCheckBox saveResults;
    private JComboBox siteComboBox;
    private JLabel siteLabel;
    private JComboBox taxonCountComboBox;
    private JLabel taxonCountLabel;
    private JComboBox taxonNameComboBox;
    private JLabel taxonNameLabel;
    private JPanel varPane;

    @Override
    protected void initCustom() {
        this.initComponents();
        this.getPlotPane().add((Component)this.plotPane, "Center");
        this.getDatasetPane().getDatasetComboBox().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TraitInferences.this.datasetComboBoxActionPerformed(e);
            }
        });
        this.refreshVariableList();
        this.refreshBioInferDatasetList();
        this.refreshValidity();
        if (System.getProperty("os.name").contains("Windows")) {
            this.setSize(480, 520);
        }
    }

    private void datasetComboBoxActionPerformed(ActionEvent e) {
        this.refreshVariableList();
        this.refreshValidity();
    }

    public void refreshVariableListValidity() {
        boolean datasetValid = this.getDatasetPane().getDatasetComboBox().getItemCount() > 0;
        this.siteLabel.setEnabled(datasetValid && this.siteComboBox.getItemCount() > 0);
        this.siteComboBox.setEnabled(datasetValid && this.siteComboBox.getItemCount() > 0);
        this.taxonNameLabel.setEnabled(datasetValid && this.taxonNameComboBox.getItemCount() > 0);
        this.taxonNameComboBox.setEnabled(datasetValid && this.taxonNameComboBox.getItemCount() > 0);
        this.taxonCountLabel.setEnabled(datasetValid && this.taxonCountComboBox.getItemCount() > 0);
        this.taxonCountComboBox.setEnabled(datasetValid && this.taxonCountComboBox.getItemCount() > 0);
    }

    public void refreshVariableList() {
        boolean datasetValid;
        boolean bl = datasetValid = this.getDatasetPane().getDatasetComboBox().getItemCount() > 0;
        if (datasetValid) {
            Vector colNames = null;
            try {
                colNames = RUtils.colnamesVector(this.getDatasetPane().getSelectedDataset());
                this.siteComboBox.setModel(new DefaultComboBoxModel(colNames));
                this.taxonNameComboBox.setModel(new DefaultComboBoxModel(colNames));
                this.taxonCountComboBox.setModel(new DefaultComboBoxModel(colNames));
                if (this.siteComboBox.getItemCount() > 0) {
                    this.siteComboBox.setSelectedIndex(0);
                }
                if (this.taxonNameComboBox.getItemCount() > 0) {
                    this.taxonNameComboBox.setSelectedIndex(0);
                }
                if (this.taxonCountComboBox.getItemCount() > 0) {
                    this.taxonCountComboBox.setSelectedIndex(0);
                }
            }
            catch (REngineException ex) {
                Logger.getLogger(TraitInferences.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (REXPMismatchException ex) {
                Logger.getLogger(TraitInferences.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            this.siteComboBox.removeAllItems();
            this.taxonNameComboBox.removeAllItems();
            this.taxonCountComboBox.removeAllItems();
        }
        this.refreshValidity();
    }

    public void refreshBioInferDatasetList() {
        String cmd = "library(bio.infer); flist.match('^trait');";
        Object currentDataset = this.coefBioInferDataComboBox.getSelectedItem();
        String[] datasets = null;
        try {
            datasets = RUtils.R_ENGINE.parseAndEval(cmd).asStrings();
            if (datasets != null && datasets.length > 0) {
                this.coefBioInferDataComboBox.setModel(new DefaultComboBoxModel<String>(datasets));
            } else {
                this.coefBioInferDataComboBox.removeAllItems();
            }
            if (this.coefBioInferDataComboBox.getModel().getSize() > 0) {
                if (currentDataset != null) {
                    this.coefBioInferDataComboBox.setSelectedItem(currentDataset);
                } else {
                    this.coefBioInferDataComboBox.setSelectedIndex(0);
                }
            }
        }
        catch (REngineException ex) {
            Logger.getLogger(TraitInferences.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (REXPMismatchException ex) {
            Logger.getLogger(TraitInferences.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.refreshCoeffValidity();
    }

    public void refreshCoeffValidity() {
        boolean biValid = this.coefBioInferDataRadioButton.isSelected();
        this.coefBioInferDataLabel.setEnabled(biValid);
        this.coefBioInferDataComboBox.setEnabled(biValid);
    }

    public void refreshSubmitButtonValidity() {
        this.getSubmitButton().setEnabled(this.getDatasetPane().getDatasetComboBox().getSelectedIndex() != -1 && this.siteComboBox.getSelectedIndex() != -1 && this.taxonNameComboBox.getSelectedIndex() != -1 && this.taxonCountComboBox.getSelectedIndex() != -1 && this.coefBioInferDataComboBox.getSelectedIndex() != -1);
    }

    public void refreshValidity() {
        this.refreshVariableListValidity();
        this.refreshCoeffValidity();
        this.refreshSubmitButtonValidity();
    }

    private void initComponents() {
        this.plotPane = new JPanel();
        this.varPane = new JPanel();
        this.siteLabel = new JLabel();
        this.siteComboBox = new JComboBox();
        this.taxonNameLabel = new JLabel();
        this.taxonNameComboBox = new JComboBox();
        this.taxonCountLabel = new JLabel();
        this.taxonCountComboBox = new JComboBox();
        this.coefPane = new JPanel();
        this.coefBioInferDataRadioButton = new JRadioButton();
        this.coefBioInferDataLabel = new JLabel();
        this.coefBioInferDataComboBox = new JComboBox();
        this.savePanel = new JPanel();
        this.saveResults = new JCheckBox();
        this.resultLabel = new JLabel();
        this.resultName = new JTextField();
        this.coefDatabuttonGroup = new ButtonGroup();
        this.varPane.setBorder(BorderFactory.createTitledBorder("Variables"));
        this.siteLabel.setText("Site ID:");
        this.siteComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TraitInferences.this.siteComboBoxActionPerformed(evt);
            }
        });
        this.taxonNameLabel.setText("Taxon Name:");
        this.taxonNameComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TraitInferences.this.taxonNameComboBoxActionPerformed(evt);
            }
        });
        this.taxonCountLabel.setText("Taxon Count:");
        this.taxonCountComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TraitInferences.this.taxonCountComboBoxActionPerformed(evt);
            }
        });
        GroupLayout varPaneLayout = new GroupLayout(this.varPane);
        this.varPane.setLayout(varPaneLayout);
        varPaneLayout.setHorizontalGroup(varPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(varPaneLayout.createSequentialGroup().addGroup(varPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(varPaneLayout.createSequentialGroup().addGap(13, 13, 13).addGroup(varPaneLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.taxonNameLabel).addComponent(this.siteLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(varPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.siteComboBox, GroupLayout.Alignment.TRAILING, 0, 352, Short.MAX_VALUE).addComponent(this.taxonNameComboBox, 0, 352, Short.MAX_VALUE))).addGroup(varPaneLayout.createSequentialGroup().addContainerGap().addComponent(this.taxonCountLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.taxonCountComboBox, 0, 352, Short.MAX_VALUE))).addContainerGap()));
        varPaneLayout.setVerticalGroup(varPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(varPaneLayout.createSequentialGroup().addContainerGap().addGroup(varPaneLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.siteComboBox, -2, -1, -2).addComponent(this.siteLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(varPaneLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.taxonNameLabel).addComponent(this.taxonNameComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(varPaneLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.taxonCountComboBox, -2, -1, -2).addComponent(this.taxonCountLabel)).addContainerGap(-1, Short.MAX_VALUE)));
        this.coefPane.setBorder(BorderFactory.createTitledBorder("Trait Data"));
        this.coefPane.setPreferredSize(new Dimension(526, 91));
        this.coefDatabuttonGroup.add(this.coefBioInferDataRadioButton);
        this.coefBioInferDataRadioButton.setSelected(true);
        this.coefBioInferDataRadioButton.setText("Select a trait dataset from the bio.infer package:");
        this.coefBioInferDataRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                TraitInferences.this.coefBioInferDataRadioButtonStateChanged(evt);
            }
        });
        this.coefBioInferDataRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TraitInferences.this.coefBioInferDataRadioButtonActionPerformed(evt);
            }
        });
        this.coefBioInferDataLabel.setText("bio.infer trait dataset:");
        this.coefBioInferDataComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TraitInferences.this.coefBioInferDataComboBoxActionPerformed(evt);
            }
        });
        GroupLayout coefPaneLayout = new GroupLayout(this.coefPane);
        this.coefPane.setLayout(coefPaneLayout);
        coefPaneLayout.setHorizontalGroup(coefPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(coefPaneLayout.createSequentialGroup().addGroup(coefPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(coefPaneLayout.createSequentialGroup().addContainerGap().addComponent(this.coefBioInferDataRadioButton)).addGroup(coefPaneLayout.createSequentialGroup().addGap(72, 72, 72).addComponent(this.coefBioInferDataLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.coefBioInferDataComboBox, -2, 219, -2))).addContainerGap(-1, Short.MAX_VALUE)));
        coefPaneLayout.setVerticalGroup(coefPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(coefPaneLayout.createSequentialGroup().addContainerGap().addComponent(this.coefBioInferDataRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(coefPaneLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.coefBioInferDataComboBox, -2, -1, -2).addComponent(this.coefBioInferDataLabel)).addContainerGap(-1, Short.MAX_VALUE)));
        this.savePanel.setBorder(BorderFactory.createTitledBorder("Results"));
        this.saveResults.setText("Save R Results?");
        this.saveResults.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.saveResults.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TraitInferences.this.saveResultsActionPerformed(evt);
            }
        });
        this.resultLabel.setText("Result Name:");
        this.resultLabel.setEnabled(false);
        this.resultName.setColumns(12);
        this.resultName.setText("traitResult");
        this.resultName.setEnabled(false);
        GroupLayout savePanelLayout = new GroupLayout(this.savePanel);
        this.savePanel.setLayout(savePanelLayout);
        savePanelLayout.setHorizontalGroup(savePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(savePanelLayout.createSequentialGroup().addGroup(savePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(savePanelLayout.createSequentialGroup().addContainerGap().addComponent(this.saveResults)).addGroup(savePanelLayout.createSequentialGroup().addGap(56, 56, 56).addComponent(this.resultLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.resultName, -1, 309, Short.MAX_VALUE))).addContainerGap()));
        savePanelLayout.setVerticalGroup(savePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(savePanelLayout.createSequentialGroup().addContainerGap().addComponent(this.saveResults).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(savePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.resultLabel).addComponent(this.resultName, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout plotPaneLayout = new GroupLayout(this.plotPane);
        this.plotPane.setLayout(plotPaneLayout);
        plotPaneLayout.setHorizontalGroup(plotPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(plotPaneLayout.createSequentialGroup().addContainerGap().addGroup(plotPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.varPane, -1, -1, Short.MAX_VALUE).addComponent(this.coefPane, -1, 520, Short.MAX_VALUE).addComponent(this.savePanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        plotPaneLayout.setVerticalGroup(plotPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(plotPaneLayout.createSequentialGroup().addContainerGap().addComponent(this.varPane, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.coefPane, -2, 115, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.savePanel, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.setTitle("Calculate Trait Metrics");
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 580) / 2, (screenSize.height - 628) / 2, 580, 628);
    }

    private void saveResultsActionPerformed(ActionEvent evt) {
        this.resultLabel.setEnabled(this.saveResults.isSelected());
        this.resultName.setEnabled(this.saveResults.isSelected());
    }

    private void siteComboBoxActionPerformed(ActionEvent evt) {
        this.refreshSubmitButtonValidity();
    }

    private void taxonNameComboBoxActionPerformed(ActionEvent evt) {
        this.refreshSubmitButtonValidity();
    }

    private void taxonCountComboBoxActionPerformed(ActionEvent evt) {
        this.refreshSubmitButtonValidity();
    }

    private void coefBioInferDataRadioButtonStateChanged(ChangeEvent evt) {
        this.refreshCoeffValidity();
    }

    private void coefBioInferDataComboBoxActionPerformed(ActionEvent evt) {
    }

    private void coefBioInferDataRadioButtonActionPerformed(ActionEvent evt) {
    }

    @Override
    protected void submitButtonAction() {
        String cmd = "bioinfer.JGR(bio.data=" + this.getDatasetPane().getSelectedDataset() + ", subset1.name=" + (this.getFactorSelectionPane1().getFactorValueList().isSelectionEmpty() ? "NULL" : "'" + this.getFactorSelectionPane1().getSelectedFactor() + "'") + ", subset1.val=" + (this.getFactorSelectionPane1().getFactorValueList().isSelectionEmpty() ? "NULL" : "c(" + RUtils.toString(this.getFactorSelectionPane1().getSelectedFactorValues(), ",", "'") + ")") + ", subset2.name=" + (this.getFactorSelectionPane2().getFactorValueList().isSelectionEmpty() ? "NULL" : "'" + this.getFactorSelectionPane2().getSelectedFactor() + "'") + ", subset2.val=" + (this.getFactorSelectionPane2().getFactorValueList().isSelectionEmpty() ? "NULL" : "c(" + RUtils.toString(this.getFactorSelectionPane2().getSelectedFactorValues(), ",", "'") + ")") + ", siteID=" + GUIUtils.getSelectedItemR(this.siteComboBox) + ", taxonName=" + GUIUtils.getSelectedItemR(this.taxonNameComboBox) + ", taxonCount=" + GUIUtils.getSelectedItemR(this.taxonCountComboBox) + ", coefBioInferData=" + GUIUtils.getBooleanValueR(this.coefBioInferDataRadioButton) + ", coefBioInferDataName=" + GUIUtils.getSelectedItemR(this.coefBioInferDataComboBox) + ", saveResults=" + GUIUtils.getBooleanValueR(this.saveResults) + ", resultName=" + RUtils.getStringValue(this.resultName.getText()) + ", tname.new=NULL" + ", dupe.sel=NULL" + ", pecboORtrait='trait'" + ")";
        JGR.MAINRCONSOLE.execute(cmd, true);
    }

    @Override
    protected void helpButtonAction() {
        String cmd = "CADStat.help('trait.stat.JGR')";
        JGR.MAINRCONSOLE.execute(cmd, true);
    }

    @Override
    public void windowActivated(WindowEvent e) {
        Object site = this.siteComboBox.getSelectedItem();
        Object tName = this.taxonNameComboBox.getSelectedItem();
        Object tCount = this.taxonCountComboBox.getSelectedItem();
        this.getDatasetPane().refreshDatasetComboBox();
        this.refreshBioInferDatasetList();
        this.siteComboBox.setSelectedItem(site);
        this.taxonNameComboBox.setSelectedItem(tName);
        this.taxonCountComboBox.setSelectedItem(tCount);
        this.refreshFactorSelectionPanes();
        this.refreshValidity();
    }
}

