/*
 * CorrelationAnalysis.java
 *
 * Created on September 20, 2005, 8:05 PM
 */

package org.neptuneinc.cadstat.plots;

import java.awt.BorderLayout;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.SpinnerNumberModel;

import org.neptuneinc.cadstat.ui.DataPlotDialog;
import org.neptuneinc.cadstat.utils.RUtils;
import org.rosuda.JGR.JGR;

/**
 *
 * @author  Pasha Minallah
 */
public class CorrelationAnalysis extends DataPlotDialog
{
  /**
   * Creates new form CorrelationAnalysis
   */
  public CorrelationAnalysis()
  {
    super();
  }

  /** Perform custom initialization. */
  @Override
  protected void initCustom()
  {
    this.initComponents();

    this.getPlotPane().add(plotPane, BorderLayout.CENTER);

    this.getDatasetPane().getDatasetComboBox().addActionListener(new ActionListener()
    {
      @Override
      public void actionPerformed(java.awt.event.ActionEvent evt)
      {
        datasetChangedAction();
      }
    });

    datasetChangedAction();

    confLevel.setModel(new SpinnerNumberModel(0.95, 0.01, 0.99, 0.01));

    updateValidity();
  }

  private void refreshVariableLists()
  {
    String dataset = this.getDatasetPane().getSelectedDataset();

    if (dataset != null)
    {
      colList2.setListData(RUtils.nonFactors(dataset));
    }
  }

  public static Object[] getSelectedItems(JList list)
  {
    if (list != null)
    {
      return(list.getSelectedValues());
    }

    else
    {
      return (null);
    }
  }

  public Object[] getVariables()
  {
    return (getSelectedItems(colList2));
  }

  /** This method is called from within the constructor to
   * initialize the form.
   * WARNING: Do NOT modify this code. The content of this method is
   * always regenerated by the Form Editor.
   */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        plotPane = new javax.swing.JPanel();
        varPane = new javax.swing.JPanel();
        varScrollPane = new javax.swing.JScrollPane();
        colList2 = new javax.swing.JList();
        analysisOptionsPane = new javax.swing.JPanel();
        scatterPlot = new javax.swing.JCheckBox();
        confIntervals = new javax.swing.JCheckBox();
        confLabel = new javax.swing.JLabel();
        confLevel = new javax.swing.JSpinner();
        methodPane = new javax.swing.JPanel();
        pearsonRadioButton = new javax.swing.JRadioButton();
        kendallRadioButton = new javax.swing.JRadioButton();
        spearmanRadioButton = new javax.swing.JRadioButton();
        savePanel = new javax.swing.JPanel();
        browserResults = new javax.swing.JCheckBox();
        methodGroup = new javax.swing.ButtonGroup();

        varPane.setBorder(javax.swing.BorderFactory.createTitledBorder("Variables"));

        varScrollPane.setPreferredSize(new java.awt.Dimension(100, 140));
        varScrollPane.setViewportView(colList2);

        org.jdesktop.layout.GroupLayout varPaneLayout = new org.jdesktop.layout.GroupLayout(varPane);
        varPane.setLayout(varPaneLayout);
        varPaneLayout.setHorizontalGroup(
            varPaneLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(varPaneLayout.createSequentialGroup()
                .addContainerGap()
                .add(varScrollPane, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 154, Short.MAX_VALUE)
                .addContainerGap())
        );
        varPaneLayout.setVerticalGroup(
            varPaneLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, varPaneLayout.createSequentialGroup()
                .addContainerGap()
                .add(varScrollPane, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 233, Short.MAX_VALUE)
                .addContainerGap())
        );

        analysisOptionsPane.setBorder(javax.swing.BorderFactory.createTitledBorder("Analysis Options"));

        scatterPlot.setText("Create Scatterplot Matrix");

        confIntervals.setText("Compute Confidence Intervals");
        confIntervals.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                confIntervalsStateChanged(evt);
            }
        });

        confLabel.setText("Confidence Level:");

        org.jdesktop.layout.GroupLayout analysisOptionsPaneLayout = new org.jdesktop.layout.GroupLayout(analysisOptionsPane);
        analysisOptionsPane.setLayout(analysisOptionsPaneLayout);
        analysisOptionsPaneLayout.setHorizontalGroup(
            analysisOptionsPaneLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(analysisOptionsPaneLayout.createSequentialGroup()
                .add(analysisOptionsPaneLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(analysisOptionsPaneLayout.createSequentialGroup()
                        .addContainerGap()
                        .add(scatterPlot))
                    .add(analysisOptionsPaneLayout.createSequentialGroup()
                        .addContainerGap()
                        .add(analysisOptionsPaneLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING, false)
                            .add(analysisOptionsPaneLayout.createSequentialGroup()
                                .add(21, 21, 21)
                                .add(confLabel)
                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                                .add(confLevel))
                            .add(confIntervals))))
                .addContainerGap(42, Short.MAX_VALUE))
        );
        analysisOptionsPaneLayout.setVerticalGroup(
            analysisOptionsPaneLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(analysisOptionsPaneLayout.createSequentialGroup()
                .addContainerGap()
                .add(scatterPlot)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(confIntervals)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(analysisOptionsPaneLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(confLabel)
                    .add(confLevel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addContainerGap())
        );

        methodPane.setBorder(javax.swing.BorderFactory.createTitledBorder("Method"));

        methodGroup.add(pearsonRadioButton);
        pearsonRadioButton.setSelected(true);
        pearsonRadioButton.setText("Pearson");

        methodGroup.add(kendallRadioButton);
        kendallRadioButton.setText("Kendall");

        methodGroup.add(spearmanRadioButton);
        spearmanRadioButton.setText("Spearman");

        org.jdesktop.layout.GroupLayout methodPaneLayout = new org.jdesktop.layout.GroupLayout(methodPane);
        methodPane.setLayout(methodPaneLayout);
        methodPaneLayout.setHorizontalGroup(
            methodPaneLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(methodPaneLayout.createSequentialGroup()
                .add(methodPaneLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(methodPaneLayout.createSequentialGroup()
                        .addContainerGap()
                        .add(pearsonRadioButton))
                    .add(methodPaneLayout.createSequentialGroup()
                        .addContainerGap()
                        .add(kendallRadioButton))
                    .add(methodPaneLayout.createSequentialGroup()
                        .addContainerGap()
                        .add(spearmanRadioButton)))
                .addContainerGap(140, Short.MAX_VALUE))
        );
        methodPaneLayout.setVerticalGroup(
            methodPaneLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(methodPaneLayout.createSequentialGroup()
                .addContainerGap()
                .add(pearsonRadioButton)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(kendallRadioButton)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(spearmanRadioButton)
                .addContainerGap())
        );

        savePanel.setBorder(javax.swing.BorderFactory.createTitledBorder("Results"));

        browserResults.setText("Display Results in Browser");
        browserResults.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        browserResults.setMargin(new java.awt.Insets(0, 0, 0, 0));
        browserResults.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                browserResultsActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout savePanelLayout = new org.jdesktop.layout.GroupLayout(savePanel);
        savePanel.setLayout(savePanelLayout);
        savePanelLayout.setHorizontalGroup(
            savePanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(savePanelLayout.createSequentialGroup()
                .addContainerGap()
                .add(browserResults)
                .addContainerGap(66, Short.MAX_VALUE))
        );
        savePanelLayout.setVerticalGroup(
            savePanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(savePanelLayout.createSequentialGroup()
                .add(browserResults)
                .addContainerGap(5, Short.MAX_VALUE))
        );

        org.jdesktop.layout.GroupLayout plotPaneLayout = new org.jdesktop.layout.GroupLayout(plotPane);
        plotPane.setLayout(plotPaneLayout);
        plotPaneLayout.setHorizontalGroup(
            plotPaneLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(plotPaneLayout.createSequentialGroup()
                .addContainerGap()
                .add(varPane, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(plotPaneLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING, false)
                    .add(methodPane, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .add(analysisOptionsPane, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .add(savePanel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        plotPaneLayout.linkSize(new java.awt.Component[] {analysisOptionsPane, methodPane}, org.jdesktop.layout.GroupLayout.HORIZONTAL);

        plotPaneLayout.setVerticalGroup(
            plotPaneLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(plotPaneLayout.createSequentialGroup()
                .addContainerGap()
                .add(plotPaneLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(varPane, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .add(plotPaneLayout.createSequentialGroup()
                        .add(methodPane, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(analysisOptionsPane, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(savePanel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 47, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)))
                .addContainerGap())
        );

        setTitle("Correlation Analysis");

        java.awt.Dimension screenSize = java.awt.Toolkit.getDefaultToolkit().getScreenSize();
        setBounds((screenSize.width-480)/2, (screenSize.height-453)/2, 480, 453);
    }// </editor-fold>//GEN-END:initComponents

  private void confIntervalsStateChanged(javax.swing.event.ChangeEvent evt)//GEN-FIRST:event_confIntervalsStateChanged
  {//GEN-HEADEREND:event_confIntervalsStateChanged
    updateValidity();
  }//GEN-LAST:event_confIntervalsStateChanged

  private void browserResultsActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_browserResultsActionPerformed
      // TODO add your handling code here:
  }//GEN-LAST:event_browserResultsActionPerformed

  private void updateValidity()
  {
    boolean enableConfLevel = confIntervals.isSelected();

    confLabel.setEnabled(enableConfLevel);
    confLevel.setEnabled(enableConfLevel);
  }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel analysisOptionsPane;
    private javax.swing.JCheckBox browserResults;
    private javax.swing.JList colList2;
    private javax.swing.JCheckBox confIntervals;
    private javax.swing.JLabel confLabel;
    private javax.swing.JSpinner confLevel;
    private javax.swing.JRadioButton kendallRadioButton;
    private javax.swing.ButtonGroup methodGroup;
    private javax.swing.JPanel methodPane;
    private javax.swing.JRadioButton pearsonRadioButton;
    private javax.swing.JPanel plotPane;
    private javax.swing.JPanel savePanel;
    private javax.swing.JCheckBox scatterPlot;
    private javax.swing.JRadioButton spearmanRadioButton;
    private javax.swing.JPanel varPane;
    private javax.swing.JScrollPane varScrollPane;
    // End of variables declaration//GEN-END:variables

  private List getColumn(JTable table, int column)
  {
    if (table != null && column <= table.getColumnCount())
    {
      List list = new ArrayList();

      for (int i = 0, n = table.getRowCount(); i < n; ++i)
      {
        list.add(table.getValueAt(i, column));
      }

      return (list);
    }

    else
    {
      return (null);
    }
  }

  @Override
  protected void submitButtonAction()
  {
    String method = null;

    if (pearsonRadioButton.isSelected())
    {
      method = "pearson";
    }

    else if (kendallRadioButton.isSelected())
    {
      method = "kendall";
    }

    else if (spearmanRadioButton.isSelected())
    {
      method = "spearman";
    }

    String cmd = "cor.JGR("
      + "my.data=" + this.getDatasetPane().getSelectedDataset()
      + ", subset1.name=" + (RUtils.toString(this.getFactorSelectionPane1().getSelectedFactorValues(), ",", "'").length()==0 ? "NULL" : "'" + this.getFactorSelectionPane1().getSelectedFactor() + "'" )
      + ", subset1.val="  + (RUtils.toString(this.getFactorSelectionPane1().getSelectedFactorValues(), ",", "'").length()==0 ? "NULL" : "c(" + RUtils.toString(this.getFactorSelectionPane1().getSelectedFactorValues(), ",", "'") + ")")
      + ", subset2.name=" + (RUtils.toString(this.getFactorSelectionPane1().getSelectedFactorValues(), ",", "'").length()==0 ? "NULL" : "'" + this.getFactorSelectionPane2().getSelectedFactor() + "'" )
      + ", subset2.val="  + (RUtils.toString(this.getFactorSelectionPane2().getSelectedFactorValues(), ",", "'").length()==0 ? "NULL" : "c(" + RUtils.toString(this.getFactorSelectionPane2().getSelectedFactorValues(), ",", "'") + ")")
      + ", my.vars=" + "c(" + RUtils.toString(getVariables(), ",", "'") + ")"
      + ", iMethod=" + "'" + method + "'"
      + ", iCI=" + String.valueOf(confIntervals.isSelected()).toUpperCase()
      + (confIntervals.isSelected() ? ", conf.level=" + ((Double) confLevel.getValue()).doubleValue() : "")
      + ", iScatterplot=" + String.valueOf(scatterPlot.isSelected()).toUpperCase()
      + ", browserResults=" + String.valueOf(browserResults.isSelected()).toUpperCase()
      + ")";
    JGR.MAINRCONSOLE.execute(cmd, true);
  }

  @Override
  protected void helpButtonAction()
  {
    String cmd = "CADStat.help('cor.JGR')";
    JGR.MAINRCONSOLE.execute(cmd, true);
//    JGR.MAINRCONSOLE.help("CorrelationAnalysis");
  }

  protected void datasetChangedAction()
  {
    refreshVariableLists();
  }

}
