% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BP_EstimateCompactness.R
\name{BP_EstimateCompactness}
\alias{BP_EstimateCompactness}
\title{Estimation of the compactness of a bone section}
\usage{
BP_EstimateCompactness(
  bone,
  center = "ontogenic",
  partial = FALSE,
  cut.angle = 60,
  cut.distance = 100,
  rotation.angle = 0,
  analysis = 1,
  show.plot = TRUE
)
}
\arguments{
\item{bone}{The bone image to be used}

\item{center}{Which center to be used: user, mineralized, unmineralized, section, ontogenic}

\item{partial}{Is the section partial?}

\item{cut.angle}{Number of angles}

\item{cut.distance}{Number of distances}

\item{rotation.angle}{The angle of rotation for analysis}

\item{analysis}{The name or rank of analysis}

\item{show.plot}{should plot is shown ?}
}
\value{
The orignial bone object with a new attribute for compactness
}
\description{
Estimation of the compactness of a bone section.\cr
The reference for radial estimation of compactness is the trigonometric circle for rotation.angle=0 in 
BP_EstimateCompactness():\cr
- The top of the section is located at -pi/2.\cr
- The left of the section is located at -pi and +pi.\cr
- The bottom of the section is located at pi/2.\cr
- The right of the section is 0.\cr
If rotation.angle is different from 0, the value of rotation.angle is added to the angle modulo 2.pi.
}
\details{
BP_EstimateCompactness estimates the compactness of a bone section
}
\examples{
\dontrun{
# Not run:
library(BoneProfileR)
 bone <- BP_OpenImage()
 # or 
path_Hedgehog <- system.file("extdata", "Erinaceus_europaeus_fem_2-1_small.png", 
                             package = "BoneProfileR")
 bone <- BP_OpenImage(file=path_Hedgehog)
 bone <- BP_DetectBackground(bone=bone)
 bone <- BP_DetectForeground(bone=bone)
 bone <- BP_DetectCenters(bone=bone)
 bone <- BP_EstimateCompactness(bone)
 plot(bone, type="original", show.grid=FALSE)
 plot(bone, type="mineralized", show.grid=FALSE)
 plot(bone, type="unmineralized", show.grid=FALSE)
 plot(bone, type="section", show.grid=FALSE)
}
}
\seealso{
Other BoneProfileR: 
\code{\link{BP_AutoFit}()},
\code{\link{BP_ChooseBackground}()},
\code{\link{BP_ChooseCenter}()},
\code{\link{BP_ChooseForeground}()},
\code{\link{BP_DetectBackground}()},
\code{\link{BP_DetectCenters}()},
\code{\link{BP_DetectForeground}()},
\code{\link{BP_DuplicateAnalysis}()},
\code{\link{BP_FitBayesianCompactness}()},
\code{\link{BP_FitMLCompactness}()},
\code{\link{BP_FitMLRadialCompactness}()},
\code{\link{BP_GetFittedParameters}()},
\code{\link{BP_ListAnalyses}()},
\code{\link{BP_LnLCompactness}()},
\code{\link{BP_OpenImage}()},
\code{\link{BP_Report}()},
\code{\link{Erinaceus_europaeus}},
\code{\link{plot.BoneProfileR}()},
\code{\link{summary.BoneProfileR}()}
}
\author{
Marc Girondot \email{marc.girondot@gmail.com}
}
\concept{BoneProfileR}
