% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/517-extractPCMPropScalesGap.R
\name{extrProtFPGap}
\alias{extrProtFPGap}
\title{Amino Acid Properties Based Scales Descriptors (Protein Fingerprint)
with Gap Support}
\usage{
extrProtFPGap(x, index = NULL, pc, lag, scale = TRUE, silent = TRUE)
}
\arguments{
\item{x}{A character vector, as the input protein sequence.
Use '\code{-}' to represent gaps in the sequence.}

\item{index}{Integer vector or character vector. Specify which AAindex
properties to select from the AAindex database by specify the
numerical or character index of the properties in the
AAindex database.
Default is \code{NULL}, means selecting all the AA properties
in the AAindex database.}

\item{pc}{Integer. Use the first pc principal components as the scales.
Must be no greater than the number of AA properties provided.}

\item{lag}{The lag parameter. Must be less than the amino acids.}

\item{scale}{Logical. Should we auto-scale the property matrix
before PCA? Default is \code{TRUE}.}

\item{silent}{Logical. Whether we print the standard deviation,
proportion of variance and the cumulative proportion of
the selected principal components or not.
Default is \code{TRUE}.}
}
\value{
A length \code{lag * p^2} named vector,
        \code{p} is the number of scales (principal components) selected.
}
\description{
Amino Acid Properties Based Scales Descriptors (Protein Fingerprint)
with Gap Support
}
\details{
This function calculates amino acid properties based scales descriptors
(protein fingerprint) with gap support. Users could specify which AAindex
properties to select from the AAindex database by specify the numerical or
character index of the properties in the AAindex database.
}
\examples{
# amino acid sequence with gaps
x = readFASTA(system.file('protseq/align.fasta', package = 'BioMedR'))$`IXI_235`
fp = extrProtFPGap(x, index = c(160:165, 258:296), pc = 5, lag = 7, silent = FALSE)

}
\author{
Min-feng Zhu <\email{wind2zhu@163.com}>, 
        Nan Xiao <\url{http://r2s.name}>
}
\keyword{AAindex}
\keyword{extract}
\keyword{gap}
\keyword{scales}
