% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/602-extractDNAIncDiv.R
\name{extrDNAIncDiv}
\alias{extrDNAIncDiv}
\alias{IncDiv}
\title{The Increment Of Diversity Descriptors}
\usage{
extrDNAIncDiv(k = 6, x, pos, neg, upto = TRUE)
}
\arguments{
\item{k}{the k value of kmer, it should be an integer larger than 0,the default value is 6.}

\item{x}{the input data, which should be a list or file type.}

\item{pos}{the positive source data, which should be a or type.}

\item{neg}{the negative source data, which should be or type.}

\item{upto}{generate all the kmers: 1mer, 2mer, ..., kmer. The output feature vector is 
the combination of all these kmers. The default value of this parameter is True}
}
\value{
if upto is True, A length \code{k * 2} named vector, \code{k} is the k value of kmer;
        if upto is False, A length 2 named vector
}
\description{
The Increment Of Diversity Descriptors
}
\details{
This function calculates the The Basic Kmer Descriptor
}
\examples{
 
pos = readFASTA(system.file('dnaseq/pos.fasta', package = 'BioMedR'))
neg = readFASTA(system.file('dnaseq/neg.fasta', package = 'BioMedR'))
x = 'GACTGAACTGCACTTTGGTTTCATATTATTTGCTC'
extrDNAIncDiv(k = 6, x, pos, neg)
}
\references{
Chen W, Luo L, Zhang L. The organization of nucleosomes around splice sites. 
\emph{Nucleic acids research}, 2010, 38(9): 2788-2798.
Liu G, Liu J, Cui X, et al. Sequence-dependent prediction of recombination hotspots in
Saccharomyces cerevisiae. \emph{Journal of theoretical biology}, 2012, 293: 49-54.
}
\seealso{
See \code{\link{extrDNAkmer}}
}
\author{
Min-feng Zhu <\email{wind2zhu@163.com}>
}
\keyword{diversity}
\keyword{extract}
\keyword{increment}
\keyword{of}
\keyword{the}
