test_extractPCMBLOSUM = function() {
    x = paste('MDAMKRGLCCVLLLCGAVFVSPSQEIHARFRRGARSYQVICRDEKTQMIYQQHQSWLRP', 
              'VLRSNRVEYCWCNSGRAQCHSVPVKSCSEPRCFNGGTCQQALYFSDFVCQCPEGFAGKCC', 
              'EIDTRATCYEDQGISYRGTWSTAESGAECTNWNSSALAQKPYSGRRPDAIRLGLGNHNYC', 
              'RNPDRDSKPWCYVFKAGKYSSEFCSTPACSEGNSDCYFGNGSAYRGTHSLTESGASCLPW', 
              'NSMILIGKVYTAQNPSAQALGLGKHNYCRNPDGDAKPWCHVLKNRRLTWEYCDVPSCSTC', 
              'GLRQYSQPQFRIKGGLFADIASHPWQAAIFAKHRRSPGERFLCGGILISSCWILSAAHCF', 
              'QERFPPHHLTVILGRTYRVVPGEEEQKFEVEKYIVHKEFDDDTYDNDIALLQLKSDSSRC', 
              'AQESSVVRTVCLPPADLQLPDWTECELSGYGKHEALSPFYSERLKEAHVRLYPSSRCTSQ', 
              'HLLNRTVTDNMLCAGDTRSGGPQANLHDACQGDSGGPLVCLNDGRMTLVGIISWGLGCGQ', 
              'KDVPGVYTKVTNYLDWIRDNMRP', sep = '')
    blosum = extrPCMBLOSUM(x, submat = 'AABLOSUM62', k = 5, lag = 7, 
                              scale = TRUE, silent = TRUE)
    pam = extrPCMBLOSUM(x, submat = 'AAPAM250', k = 3, lag = 9, 
                           scale = TRUE, silent = TRUE)
    checkEquals(length(blosum), 175L)
    checkEquals(length(pam), 81L)
}
