% package: BayesLogit
\name{rpg}

\alias{rpg}
\alias{rpg.devroye}
\alias{rpg.gamma}
\alias{rpg.alt}
\alias{rpg.sp}
%\alias{rpg.gamma.R}
%\alias{rpg.devroye.R}

\title{The Polya-Gamma Distribution}

\description{
  Generate a random variate from the Polya-Gamma distribution.
}

\details{

  A random variable X with distribution PG(n,z) is generated by

  \deqn{ X \sim \sum_{k=1}^\infty G(n,1) / ( 2 \pi^2 (k-1/2)^2 + z^2/2). }

  The density for X may be derived from Z and PG(n,0) as

  \deqn{ p(x|n,z) \propto \exp(-x z^2/2) p(x|n,0).}

  Thus PG(n,z) is an exponentially tilted PG(n,0).

  Two different methods for generating this random variable are
  implemented.  In general, you may use rpg.gamma to generate an
  approximation of PG(n,z) using the sum of Gammas representation
  above.  When n is a natural number you may use \code{rpg.devroye} to
  sample PG(n,z).  The later method is fast.

}

\usage{

rpg(num=1, h=1, z=0.0)

rpg.gamma(num=1, h=1, z=0.0, trunc=200)

rpg.devroye(num=1, n=1, z=0.0)

rpg.alt(num=1, h=1, z=0.0)

rpg.sp(num=1, h=1, z=0.0, track.iter=FALSE)

}

% rpg.gamma.R(num=1, n=1, z=0.0, trunc=200)

% rpg.devroye.R(num=1, n=1, z=0.0)

\arguments{
	
  You may call rpg when n and z are vectors.

  \item{num}{The number of random variates to simulate.}
  \item{n}{Shape parameter, a positive integer}
  \item{h}{Shape parameter.  code{h} >= 1 if not using sum of gammas method.}
  \item{z}{Parameter associated with tilting.}
  \item{trunc}{The number of elements used in sum of gammas approximation.}
  \item{track.iter}{The number of proposals made before accepting.}
}

\value{

  This function returns \code{num} Polya-Gamma samples.

}

\examples{

h = c(1, 2, 3);
z = c(4, 5, 6);

## If h contains small integers, e.g. {1,2,3}, use Devroye-like method.
X = rpg.devroye(100, h, z);

h = c(1.2, 2.3, 3.2);
z = c(4, 5, 6);

## Else if h contains scalars >=1 or larger integers use alternate Devroye-like method.
X = rpg(100, h, z);

## Else sum of gammas method -- this is slow.
X = rpg.gamma(100, h, z);

}

\seealso{
  \code{\link{logit.EM}}, \code{\link{logit}}, \code{\link{mlogit}}
}

\references{
  Nicholas G. Polson, James G. Scott, and Jesse Windle.  Bayesian inference for
  logistic models using Polya-Gamma latent variables.
  \url{http://arxiv.org/abs/1205.0310}
}

\keyword{rpg}
\keyword{Polya-Gamma}
\keyword{polyagamma}
