% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{lps}
\alias{lps}
\alias{lps.bgvar.pred}
\title{Compute Log-Predictive Scores}
\usage{
\method{lps}{bgvar.pred}(object, ...)
}
\arguments{
\item{object}{An object of class \code{bgvar.predict}.}

\item{...}{Additional arguments.}
}
\value{
Returns an object of class \code{bgvar.lps}, which is a matrix of dimension h times K, whereas h is the forecasting horizon and K is the number of variables in the system.
}
\description{
Computes and prints log-predictive score of an object of class \code{bgvar.predict}.
}
\examples{
\donttest{
library(BGVAR)
data(testdata)
model.ssvs.eer<-bgvar(Data=testdata,W=W.test,draws=100,burnin=100,
                      plag=1,prior="SSVS",eigen=TRUE,hold.out=8)
fcast <- predict(model.ssvs.eer,n.ahead=8,save.store=TRUE)
lps <- lps(fcast)
}
}
\author{
Maximilian Boeck, Martin Feldkircher
}
