% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Bayes_CREM.R
\name{Bayes_CREM}
\alias{Bayes_CREM}
\title{Bayesian Crossed Random Effects Model (CREM)}
\usage{
Bayes_CREM(
  data,
  ind_id_var,
  cross_id_var,
  time_var,
  y_var,
  form = "linear",
  fixed_effects = NULL,
  iters_adapt = 5000,
  iters_burn_in = 50000,
  iters_sampling = 50000,
  thin = 15,
  save_full_chains = FALSE,
  save_conv_chains = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{data}{Data frame in long format, where each row describes a measurement occasion for a given individual. It is assumed that each individual has the same number of assigned timepoints (a.k.a., rows). There can be missingness in the outcome (\code{y_var}), but there cannot be missingness in time (\code{time_var}).}

\item{ind_id_var}{Name of column that contains ids for individuals with repeated measures in a longitudinal dataset (e.g., students).}

\item{cross_id_var}{Name of column that contains ids for the crossed factor (e.g., teachers).}

\item{time_var}{Name of column that contains the time variable. This column cannot contain any missing values.}

\item{y_var}{Name of column that contains the outcome variable. Missing values should be denoted by NA.}

\item{form}{Name of the functional form. Options include: ‘linear’ (default), ‘quadratic’, ‘exponential’, ‘piecewise’.}

\item{fixed_effects}{(optional) Starting values for the fixed effects parameters.}

\item{iters_adapt}{(optional) Number of iterations for adaptation of jags model (default = 5000).}

\item{iters_burn_in}{(optional) Number of iterations for burn-in (default = 50000).}

\item{iters_sampling}{(optional) Number of iterations for posterior sampling (default = 50000).}

\item{thin}{(optional) Thinning interval for posterior sampling (default = 15).}

\item{save_full_chains}{Logical indicating whether the MCMC chains from rjags should be saved (default = FALSE). Note, this should not be used regularly as it will result in an object with a large file size.}

\item{save_conv_chains}{Logical indicating whether the MCMC chains from rjags should be saved but only for the parameters monitored for convergence (default = FALSE). This would be useful for plotting traceplots for relevant model parameters to evaluate convergence behavior. Note, this should not be used regularly as it will result in an object with a large file size.}

\item{verbose}{Logical controlling whether progress messages/bars are generated (default = TRUE).}
}
\value{
A list (an object of class \code{CREM}) with elements:
\item{Convergence}{Potential scale reduction factor (PSRF) for each parameter (\code{parameter_psrf}), Gelman multivariate scale reduction factor (\code{multivariate_psrf}), and mean PSRF (\code{mean_psrf}) to assess model convergence.}
\item{Model_Fit}{Deviance (\code{deviance}), effective number of parameters (\code{pD}), and Deviance information criterion (\code{dic}) to assess model fit.}
\item{Fitted_Values}{Vector giving the fitted value at each timepoint for each individual (same length as long data).}
\item{Functional_Form}{Functional form fitted.}
\item{Parameter_Estimates}{Data frame with posterior mean and 95\% credible intervals for each model parameter.}
\item{Run_Time}{Total run time for model fitting.}
\item{Full_MCMC_Chains}{If save_full_chains=TRUE, raw MCMC chains from rjags.}
\item{Convergence_MCMC_Chains}{If save_conv_chains=TRUE, raw MCMC chains from rjags but only for the parameters monitored for convergence.}
}
\description{
Estimates a Bayesian crossed random effects models (CREM) for longitudinal data with dynamic group membership. Four different choices for functional forms are provided: linear, quadratic, exponential, and piecewise. See Rohloff et al. (2024) for more details.
}
\details{
For more information on the model equation and priors implemented in this function, see Rohloff et al. (2024).

Note, this function differs from the above reference by estimating the covariances between the random effects parameters. The variance-covariance matrices of the individual and group random effects have a scaled inverse-Wishart prior (see Peralta et al., 2022).
}
\examples{
\donttest{
# load simulated data
data(SimData_PCREM)
# plot observed data
plot_BEND(data = SimData_PCREM,
          id_var = "id",
          time_var = "time",
          y_var = "y")
# fit Bayes_CREM()
results_pcrem <- Bayes_CREM(data = SimData_PCREM,
                            ind_id_var = "id",
                            cross_id_var = "teacherid",
                            time_var = "time",
                            y_var = "y",
                            form="piecewise")
# result summary
summary(results_pcrem)
# plot fitted results
plot_BEND(data = SimData_PCREM,
          id_var = "id",
          time_var = "time",
          y_var = "y",
          results = results_pcrem)
}

}
\references{
Peralta, Y., Kohli, N., Lock, E. F., & Davison, M. L. (2022). Bayesian modeling of associations in bivariate piecewise linear mixed-effects models. Psychological Methods, 27(1), 44–64. https://doi.org/10.1037/met0000358

Rohloff, C. T., Kohli, N., & Lock, E. F. (2024). Identifiability and estimability of Bayesian linear and nonlinear crossed random effects models. British Journal of Mathematical and Statistical Psychology. https://doi.org/10.1111/bmsp.12334
}
\author{
Corissa T. Rohloff
}
