% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/occurrence.R, R/plot.R
\docType{methods}
\name{occurrence}
\alias{occurrence}
\alias{occurrence-method}
\alias{occurrence,EventsMCMC-method}
\alias{plot,OccurrenceEvents,missing-method}
\title{Occurrence Plot}
\usage{
occurrence(object, ...)

\S4method{occurrence}{EventsMCMC}(object, level = 0.95)

\S4method{plot}{OccurrenceEvents,missing}(
  x,
  calendar = getOption("ArchaeoPhases.calendar"),
  main = NULL,
  sub = NULL,
  ann = graphics::par("ann"),
  axes = TRUE,
  frame.plot = axes,
  panel.first = NULL,
  panel.last = NULL,
  ...
)
}
\arguments{
\item{object}{An \code{\linkS4class{EventsMCMC}} object.}

\item{...}{Other \link[graphics:par]{graphical parameters} may also be passed as
arguments to this function, particularly, \code{border}, \code{col}, \code{lwd}, \code{lty} or
\code{pch}.}

\item{level}{A length-one \code{\link{numeric}} vector giving the confidence level.}

\item{x}{An \code{\linkS4class{OccurrenceEvents}} object.}

\item{calendar}{A \code{\linkS4class{TimeScale}} object specifying the target calendar
(see \code{\link[=calendar]{calendar()}}).}

\item{main}{A \code{\link{character}} string giving a main title for the plot.}

\item{sub}{A \code{\link{character}} string giving a subtitle for the plot.}

\item{ann}{A \code{\link{logical}} scalar: should the default annotation (title and x
and y axis labels) appear on the plot?}

\item{axes}{A \code{\link{logical}} scalar: should axes be drawn on the plot?}

\item{frame.plot}{A \code{\link{logical}} scalar: should a box be drawn around the
plot?}

\item{panel.first}{An an \code{expression} to be evaluated after the plot axes are
set up but before any plotting takes place. This can be useful for drawing
background grids.}

\item{panel.last}{An \code{expression} to be evaluated after plotting has taken
place but before the axes, title and box are added.}
}
\value{
\itemize{
\item \code{occurrence()} returns an \code{\linkS4class{OccurrenceEvents}} object.
\item \code{plot()} is called it for its side-effects: it results in a graphic being
displayed (invisibly returns \code{x}).
}

An \code{\linkS4class{OccurrenceEvents}} object.
}
\description{
A statistical graphic designed for the archaeological study of when
events of a specified kind occurred.
}
\details{
If we have \eqn{k} events, then we can estimate the calendar date \eqn{t}
corresponding to the smallest date such that the number of events observed
before \eqn{t} is equal to \eqn{k}.

The \code{occurrence()} estimates these occurrences and gives the credible
interval or the highest posterior density (HPD) region for a given \code{level}
of confidence.
}
\examples{
## Coerce to MCMC
eve <- as_events(mcmc_events, calendar = CE(), iteration = 1)
eve <- eve[1:10000, ]

## Occurrence plot
occ <- occurrence(eve)
plot(occ, panel.first = graphics::grid())
}
\seealso{
Other event tools: 
\code{\link{activity}()},
\code{\link{elapse}()},
\code{\link{tempo}()}
}
\author{
A. Philippe, M.-A. Vibet, T. S. Dye, N. Frerebeau
}
\concept{event tools}
