% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MannWhitneyTest.R
\name{MWTest}
\alias{MWTest}
\title{Mann-Whitney U Test (Wilcoxon Rank-Sum, Manual Implementation)}
\usage{
MWTest(
  grupo1,
  grupo2,
  alpha = 0.05,
  alternative = c("two.sided", "less", "greater"),
  continuity = TRUE
)
}
\arguments{
\item{grupo1}{Numeric vector for the first group.}

\item{grupo2}{Numeric vector for the second group.}

\item{alpha}{Significance level (default = 0.05).}

\item{alternative}{Character string specifying the alternative hypothesis.
Options are \code{"two.sided"} (default), \code{"less"}, or \code{"greater"}.}

\item{continuity}{Logical indicating whether to apply continuity correction (default = TRUE).}
}
\value{
An object of class \code{"comparacion"} and \code{"mannwhitney"}, containing:
\itemize{
  \item \code{Resultados}: A data frame with the comparison name, difference in means, p-value, and significance.
  \item \code{Promedios}: A named numeric vector of group means.
  \item \code{Orden_Medias}: A character vector of group names ordered from highest to lowest mean.
  \item \code{Metodo}: A string describing the test and hypothesis direction.
}
}
\description{
Performs the Mann-Whitney U test (Wilcoxon rank-sum) for two independent groups,
using a manual implementation. Suitable when the assumptions of parametric tests
(normality, homogeneity of variances) are not met.
}
\details{
Advantages:
- Does not assume normality.
- More powerful than t-test for skewed distributions.

Disadvantages:
- Only compares two groups at a time.
- Sensitive to unequal variances or shapes.

This implementation allows one- or two-sided alternatives and optionally applies a continuity correction.
}
\examples{
data(d_e, package = "Analitica")
g1 <- d_e$Sueldo_actual[d_e$labor == 1]
g2 <- d_e$Sueldo_actual[d_e$labor == 2]
resultado <- MWTest(g1, g2, alternative = "greater")
summary(resultado)

}
\references{
Mann, H. B., & Whitney, D. R. (1947). "On a Test of Whether One of Two Random Variables is Stochastically Larger than the Other." \emph{Annals of Mathematical Statistics}, 18(1), 50–60.
}
