% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bar_error.R
\name{bar_error}
\alias{bar_error}
\title{Bar Plot with Error Bars (Standard Deviation or Standard Error)}
\usage{
bar_error(
  dataSet,
  vD,
  vI,
  variation = "sd",
  title = "Bar plot with error bars",
  label_y = "Y Axis",
  label_x = "X Axis"
)
}
\arguments{
\item{dataSet}{A \code{data.frame} or \code{tibble} containing the data.}

\item{vD}{A string indicating the name of the numeric dependent variable.}

\item{vI}{A string indicating the name of the categorical independent variable (grouping variable).}

\item{variation}{Type of variation to display: \code{"sd"} for standard deviation
or \code{"se"} for standard error. Default is \code{"sd"}.}

\item{title}{Title of the plot. Default is \code{"Bar plot with error bars"}.}

\item{label_y}{Label for the Y-axis. Default is \code{"Y Axis"}.}

\item{label_x}{Label for the X-axis. Default is \code{"X Axis"}.}
}
\value{
A \code{ggplot} object representing the plot.
}
\description{
Creates a bar plot of group means with error bars representing either
the standard deviation (SD) or the standard error (SE).
}
\examples{
data(d_e, package = "Analitica")
bar_error(d_e, vD = Sueldo_actual, vI = labor, variation = "sd")

}
