% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allelic_series.R
\name{Aggregator}
\alias{Aggregator}
\title{Aggregator}
\usage{
Aggregator(
  anno,
  geno,
  drop_empty = TRUE,
  indicator = FALSE,
  method = "none",
  min_mac = 0,
  weights = c(1, 2, 3)
)
}
\arguments{
\item{anno}{(snps x 1) annotation vector with integer values in 1 through
the number of annotation categories L.}

\item{geno}{(n x snps) genotype matrix.}

\item{drop_empty}{Drop empty columns? Default: TRUE.}

\item{indicator}{Convert raw counts to indicators? Default: FALSE.}

\item{method}{Method for aggregating across categories:
("none", "max", "sum"). Default: "none".}

\item{min_mac}{Minimum minor allele count for inclusion. Default: 0.}

\item{weights}{(L x 1) vector of annotation category weights. Note that the
number of annotation categories L is inferred from the length of \code{weights}.}
}
\value{
(n x L) Numeric matrix without weighting, (n x 1) numeric matrix
with weighting.
}
\description{
Aggregates genotypes within annotation categories.
}
\section{Notes}{

\itemize{
\item Ensure the length of the \code{weights} vector matches the total number of
annotation categories.
\item The \code{weights} essentially scales the minor allele count in the \code{l}th
category by \code{weights[l]}.
}
}

