% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rARS.R
\name{rARS}
\alias{rARS}
\title{Adaptive Rejection Sampling Algorithm
rARS generates a sequence of random variables using ARS algorithm.}
\usage{
rARS(n, formula, min = -Inf, max = Inf, sp)
}
\arguments{
\item{n}{Desired sample size}

\item{formula}{Kernal density of target log target density}

\item{min, max}{Domain including positive and negative infinity}

\item{sp}{Supporting set.}
}
\description{
Adaptive Rejection Sampling Algorithm
rARS generates a sequence of random variables using ARS algorithm.
}
\examples{
###Running the following codes my take you a few minutes!

#Standard normal distribution
x<-rARS(100,"exp(-x^2/2)",-Inf,Inf,c(-2,2))

#Truncated normal distribution
rARS(100,"exp(-x^2/2)",-2.1,2.1,c(-2,2))

#Normal distribution with mean=2 and sd=2
rARS(100,"exp(-(x-2)^2/(2*4))",-Inf,Inf,c(-3,3))

#Exponential distribution with rate=3
rARS(100,"exp(-3*x)",0,Inf,c(2,3,100))

#Beta distribution
rARS(100,"x^2*(1-x)^3",0,1,c(0.4,0.6))

#Gamma distribution
rARS(100,"x^(5-1)*exp(-2*x)",0,Inf,c(1,10))

#Student distribution
rARS(100,"(1+x^2/10)^(-(10+1)/2)",-Inf,Inf,c(-10,2))

#F distribution
rARS(100,"x^(10/2-1)/(1+10/5*x)^(15/2)",0,Inf,c(3,10))

#Cauchy distribution
rARS(100,"1/(1+(x-1)^2)",-Inf,Inf,c(-2,2,10))

#Rayleigh distribution with lambda=1
rARS(100,"2*x*exp(-x^2)",0,Inf,c(0.01,10))
}
\author{
Zhangdong<\url{dzhang0716@126.com}>
}
