% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monitor_nowcast.R
\name{monitor_nowcast}
\alias{monitor_nowcast}
\title{Apply NowCast algorithm to \emph{mts_monitor} data}
\usage{
monitor_nowcast(
  monitor,
  version = c("pm", "pmAsian", "ozone"),
  includeShortTerm = FALSE
)
}
\arguments{
\item{monitor}{\emph{mts_monitor} object.}

\item{version}{Name of the type of nowcast algorithm to be used.}

\item{includeShortTerm}{Logical specifying whether to alcluate preliminary
NowCast values starting with the 2nd hour.}
}
\value{
A modified \code{mts_monitor} object. (A list with
\code{meta} and \code{data} dataframes.)
}
\description{
A NowCast algorithm is applied to the data in in the
\code{monitor} object. The \code{version} argument specifies the minimum
weight factor and number of hours to be used in the calculation.

Available versions include:
\enumerate{
\item{\code{pm}: hours = 12, weight = 0.5}
\item{\code{pmAsian}: hours = 3, weight = 0.1}
\item{\code{ozone}: hours = 8, weight = NA}
}

The default, \code{version = "pm"}, is appropriate for typical usage.
}
\details{
This function calculates each hour's NowCast value based on the value
for the given hour and the previous N-1 hours, where N is the number
of hours appropriate for the \code{version} argument. For example, if
\code{version = "pm"}, the NowCast value for Hour 12 is based on the data
from hours 1-12.

The function returns values when at least two of the previous three hours
have data. NA's are returned for hours where this condition is not met.

By default, the funtion will not return a valid value until the Nth hour.
If \code{includeShortTerm = TRUE}, the function will return a valid value
after only the 2nd hour (provided, of course, that both hours are valid).

Calculated Nowcast values are truncated to the nearest .1 ug/m3 for 'pm' and
nearest .001 ppm for 'ozone' regardless of the precision of the data in the
incoming \emph{mts_monitor} object.
}
\references{
\url{https://en.wikipedia.org/wiki/Nowcast_(Air_Quality_Index)}

\href{https://document.airnow.gov/technical-assistance-document-for-the-reporting-of-daily-air-quailty.pdf}{AQI Technical Assistance Document}
}
