% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kansuji.R
\name{kansuji2arabic}
\alias{kansuji2arabic}
\alias{kansuji2arabic_all}
\title{Convert kansuji character to arabic}
\usage{
kansuji2arabic(str, convert = TRUE, .under = Inf)

kansuji2arabic_all(str, ...)
}
\arguments{
\item{str}{Input vector.}

\item{convert}{If \code{FALSE}, will return as numeric. The default value is \code{TRUE},
and numeric values are treated as strings.}

\item{.under}{Number scale to be converted. The default value is infinity.}

\item{...}{Other arguments to carry over to \code{kansuji2arabic()}}
}
\value{
a character or numeric.
}
\description{
\Sexpr[results=rd, stage=render]{lifecycle::badge("experimental")}
Converts a given Kansuji element such as Ichi (1) and Nana (7) to an Arabic.
\code{kansuji2arabic_all()} converts only Kansuji in the string.
}
\examples{
kansuji2arabic("\u4e00")
kansuji2arabic(c("\u4e00", "\u767e"))
kansuji2arabic(c("\u4e00", "\u767e"), convert = FALSE)
# Keep Kansuji over 1000.
kansuji2arabic(c("\u4e00", "\u767e", "\u5343"), .under = 1000)
# Convert all character
kansuji2arabic_all("\u3007\u4e00\u4e8c\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d\u5341")
kansuji2arabic_all("\u516b\u4e01\u76ee")
}
