% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zfit_base_zfunction_zfitter.R
\docType{package}
\name{zfit}
\alias{zfit}
\title{zfit: Fit Models in a Pipe}
\description{
The goal of 'zfit' is to improve the usage of basic
model fitting functions within a piped work flow, in particular
when passing and processing a data.frame using 'dplyr' or
similar packages.
}
\details{
The goal of \code{zfit} is to make it easier to use a piped workflow with
functions that don’t have the “correct” order of parameters (the first
parameter of the function does not match the object passing through the
pipe). This issue is especially prevalent with model fitting functions,
such as when passing and processing a \code{data.frame} (or \code{tibble}) before
passing them to \code{lm()} or similar functions. The pipe passes the data
object (\code{data.frame}/\code{tibble}) into the first parameter of the function,
but the conventional estimation functions expect a formula to be the
first parameter.

When using \code{magrittr} style pipes (\verb{\%>\%}), this can be addressed by
using special syntax, specifying \code{data=.} to pass the piped data into a
parameter other than the first one. With R native pipes (\verb{|>}), however,
this is not possible and workaround are needed (such as constructing an
anonymous function for each estimation or relying on complex rules about
how piped arguments are interpreted in the presence of named
parameters).

To address this, this package includes functions such as
\code{\link[=zlm]{zlm()}} and \code{\link[=zglm]{zglm()}}. These are very similar to the
core estimation functions such as \code{lm()} and \code{glm()}, but expect the
first argument to be a (\code{data.frame}/\code{tibble}) rather than a formula
(the formula becomes the second argument).

More importantly, the package includes two functions that make it
trivial to construct a pipe-friendly version of any function. The
\code{\link[=zfitter]{zfitter()}} function takes any estimation function with the
standard format of a \code{formula} and \code{data} parameter, and returns a
version suitable for us in pipes (with the \code{data} parameter coming
first). The \code{\link[=zfitter]{zfitter()}} function also does some special
handling to make make the call information more useful.

The \code{\link[=zfunction]{zfunction()}} works for any function but omits the
special handling for call parameters. Just pass the name of a function,
and the name of the parameter that should receive the piped argument,
and it returns a version of the function with that parameter coming
first.

The package also includes the \code{\link[=zprint]{zprint()}} function, which is
intended to simplify the printing of derived results, such as
\code{summary()}, within the pipe, without affecting the modeling result
itself. It also includes convenience functions for calling estimation
functions using particular parameters, including \code{\link[=zlogit]{zlogit()}}
and \code{\link[=zprobit]{zprobit()}}, and \code{\link[=zpoisson]{zpoisson()}}, to perform
logistic or poisson regression within a pipe.

\emph{Note that some of the examples provided in the help and documentation
use magrittr-style (\verb{\%>\%}) pipe syntax, while others use the native pipe
syntax (\verb{|>}). The package has been tested with both types of pipe
functionality and the results are identical, apart from the fact that
\verb{\%>\%} renames the piped argument to \code{.}, whereas the name of the piped
argument is the complete nested function syntax of the pipe.}
}
\seealso{
\itemize{
\item \link{zlm} is the wrapper \code{lm}, probably the most common fitting
function. The help file for this function includes several
usage examples.
\item \link{zglm} is a wrapper for \code{glm}, to fit generalized
linear models.
\item \link{zprint} is helpful for printing a \code{summary} of a model,
but assigning the evaluated model to a variable
}
}
