% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zfit.R
\name{zprint}
\alias{zprint}
\title{Print the result of a function in a pipe but return original object}
\usage{
zprint(x, f, ...)
}
\arguments{
\item{x}{An object, typically in a pipe}

\item{f}{A function to be applied to \code{x} before printing}

\item{...}{Other arguments to be passed to \code{f}}
}
\value{
The original object \code{x}
}
\description{
This function passes \code{x} to \code{f} and prints the result, but then
returns the original \code{x}. It is useful in a pipe, when one wants a
to print the derivative of an object in the pipe but then return or assign
the original object. An example is printing the \code{summary()} of an
estimated model but
}
\examples{
m <- lm( speed ~ dist, cars) \%>\%
  zprint(summary) # prints summary(x)
m                 # m is the original model object

if(require("dplyr")) {
  cw_subset <- chickwts \%>\%
    zprint(count, feed, sort=TRUE) \%>\% # prints counts by feed
    filter(feed=="soybean")
  cw_subset # cw_subset is ungrouped, but filtered by feed
}

}
\seealso{
Other zfit: 
\code{\link{zglm}()},
\code{\link{zlm}()},
\code{\link{zlogit}()},
\code{\link{zprobit}()}
}
\concept{zfit}
