% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bowlerCumulativeAvgWickets.R
\name{bowlerCumulativeAvgWickets}
\alias{bowlerCumulativeAvgWickets}
\title{Bowler's cumulative average wickets}
\usage{
bowlerCumulativeAvgWickets(df,name,dateRange,staticIntv1=1)
}
\arguments{
\item{df}{Data frame}

\item{name}{Name of batsman}

\item{dateRange}{Date interval to consider}

\item{staticIntv1}{Static or interactive -staticIntv1 =1 (static plot) &  staticIntv1 =2 (interactive  plot)}
}
\value{
None
}
\description{
This function computes and plots the cumulative average wickets of a bowler
}
\note{
Maintainer: Tinniam V Ganesh \email{tvganesh.85@gmail.com}
}
\examples{
\dontrun{)
#'Get the data frame for RA Jadeja
jadeja <- getBowlerWicketDetails(team="India",name="Jadeja",dir=pathToFile)
bowlerCumulativeAvgWickets(jadeja,"RA Jadeja",dateRange)
}
}
\references{
\url{https://cricsheet.org/}\cr
\url{https://gigadom.in/}\cr
\url{https://github.com/tvganesh/yorkrData/}
}
\seealso{
\code{\link{batsmanCumulativeAverageRuns}}
\code{\link{bowlerCumulativeAvgEconRate}}
\code{\link{batsmanCumulativeStrikeRate}}
\code{\link{batsmanRunsVsStrikeRate}}
\code{\link{batsmanRunsPredict}}
}
\author{
Tinniam V Ganesh
}
