% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{metrics}
\alias{metrics}
\alias{metrics.data.frame}
\title{General Function to Estimate Performance}
\usage{
metrics(data, ...)

\method{metrics}{data.frame}(data, truth, estimate, ..., options = list(),
  na.rm = TRUE)
}
\arguments{
\item{data}{A data frame}

\item{...}{For classification: a set of unquoted column names
or one or more \code{dplyr} selector functions to choose which
variables contain the class probabilities. See the examples
below. For \code{roc_auc} and \code{pr_auc}, only one value is required.
If more are given, the functions will try to match the column
name to the appropriate factor level of \code{truth}. If this doesn't
work, an error is thrown. For \code{mnLogLoss}, there should be as
many columns as factor levels of \code{truth}. It is \strong{assumed} that
they are in the same order as the factor levels.}

\item{truth}{The column identifier for the true results (that
is numeric or factor). This should an unquoted column name
although this argument is passed by expression and support
\link[rlang:quasiquotation]{quasiquotation} (you can unquote column
names or column positions).}

\item{estimate}{The column identifier for the predicted results
(that is also numeric or factor). As with \code{truth} this can be
specified different ways but the primary method is to use an
unquoted variable name.}

\item{options}{Options to pass to \code{\link[=roc]{roc()}} such as \code{direction} or
\code{smooth}. These options should not include \code{response},
\code{predictor}, or \code{levels}.}

\item{na.rm}{A logical value indicating whether \code{NA}
values should be stripped before the computation proceeds.}
}
\value{
A single row tibble. When \code{truth} is a factor, there is
an \code{\link[=accuracy]{accuracy()}} column. If a full set of class probability
columns are passed to \code{...}, then there is also a column for
\code{\link[=mnLogLoss]{mnLogLoss()}}. When \code{truth} has two levels and there are class
probabilities, \code{\link[=roc_auc]{roc_auc()}} is appended. When \code{truth} is numeric,
there are columns for \code{\link[=rmse]{rmse()}} and \code{\link[=rsq]{rsq()}},

A number or \code{NA}
}
\description{
This function estimates one or more common performance
estimates depending on the class of \code{truth} (see \strong{Value}
below) and returns them in a single row tibble.
}
