% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xtune.R
\name{xtune.control}
\alias{xtune.control}
\title{Control function for xtune fitting}
\usage{
xtune.control(alpha.init = NULL, maxstep = 100, tolerance = 0.001,
  maxstep_inner = 50, tolerance_inner = 0.1, compute.likelihood = FALSE,
  verbosity = FALSE, standardize = TRUE, intercept = TRUE)
}
\arguments{
\item{alpha.init}{initial values of alpha vector supplied to the algorithm.
alpha values are the hyper-parameters for the double exponential prior of regression coefficients,
 and it controls the prior variance of regression coefficients. Default is a vector of 0 with length p.}

\item{maxstep}{Maximum number of iterations. Default is 100.}

\item{tolerance}{Convergence threshold. Default is 1e-4.}

\item{maxstep_inner}{Maximum number of iterations for the inner loop of the majorization-minimization algorithm.}

\item{tolerance_inner}{Convergence threshold for the inner loop of the majorization-minimization algorithm.}

\item{compute.likelihood}{Should the function compute the marginal likelihood for hyper-parameters at each step of the update? Default is TRUE.}

\item{verbosity}{Track algorithm update process? Default is FALSE.}

\item{standardize}{Standardize X or not, same as the standardized option in glmnet}

\item{intercept}{Should intercept(s) be fitted (default=TRUE) or set to zero (FALSE), same as the intercept option in glmnet}
}
\description{
Control function for \code{\link{xtune}} fitting.
}
