% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write.R
\name{xportr_write}
\alias{xportr_write}
\title{Write xpt v5 transport file}
\usage{
xportr_write(.df, path, label = NULL, strict_checks = FALSE)
}
\arguments{
\item{.df}{A data frame to write.}

\item{path}{Path where transport file will be written. File name sans will be
used as \code{xpt} name.}

\item{label}{Dataset label. It must be <=40 characters.}

\item{strict_checks}{If TRUE, xpt validation will report errors and not write
out the dataset. If FALSE, xpt validation will report warnings and continue
with writing out the dataset. Defaults to FALSE}
}
\value{
A data frame. \code{xportr_write()} returns the input data invisibly.
}
\description{
Writes a local data frame into SAS transport file of version 5. The SAS
transport format is an open format, as is required for submission of the data
to the FDA.
}
\details{
\itemize{
\item Variable and dataset labels are stored in the "label" attribute.
\item SAS length are stored in the "SASlength" attribute.
\item SAS format are stored in the "SASformat" attribute.
\item SAS type are stored in the "SAStype" attribute.
}
}
\examples{
adsl <- data.frame(
  Subj = as.character(123, 456, 789),
  Different = c("a", "b", "c"),
  Val = c("1", "2", "3"),
  Param = c("param1", "param2", "param3")
)

xportr_write(adsl,
  path = paste0(tempdir(), "/adsl.xpt"),
  label = "Subject-Level Analysis",
  strict_checks = FALSE
)

}
