% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selectState.R
\name{selectState}
\alias{selectState}
\title{Select transition state}
\usage{
selectState(uni, wt)
}
\arguments{
\item{uni}{Uniform random number between 0 and 1.}

\item{wt}{Cumulative probability vector of states.}
}
\value{
Returns an object containing the transition state(s) based on the given cumulative probability vector and random numbers.
}
\description{
Function selects and returns the transition state given a uniform random number between 0 and 1 and
the cumulative probability vector of the state sequence.
}
\examples{

 rand = runif(1)

 print(rand)

 selectState(uni = rand, wt = c(0.25, .55, 0.85, 1))


}
