% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stdErrMedBoot.R
\name{stdErrMedBoot}
\alias{stdErrMedBoot}
\title{Standard eror of median by boot-strap}
\usage{
stdErrMedBoot(x, nBoot = 99)
}
\arguments{
\item{x}{(numeric) vector to estimate median and it's standard error}

\item{nBoot}{(integer) number for iterations}
}
\value{
This function returns a (numeric) vector with estimated standard error
}
\description{
\code{stdErrMedBoot} estimate standard eror of median by boot-strap approach. 
Note: requires package \href{https://CRAN.R-project.org/package=boot}{boot}
}
\examples{
set.seed(2014); ra1 <- c(rnorm(9,2,1),runif(8,1,2))
rat1 <- ratioAllComb(ra1[1:9],ra1[10:17])
median(rat1); stdErrMedBoot(rat1)
}
\seealso{
\code{\link[boot]{boot}}
}
