% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extrColsDeX.R
\name{extrColsDeX}
\alias{extrColsDeX}
\title{Flexible extraction of columns}
\usage{
extrColsDeX(x, extrCol, doExtractCols = FALSE, callFrom = NULL, silent = FALSE)
}
\arguments{
\item{x}{(matrix or data.frame) main input (where data should be extracted from)}

\item{extrCol}{(character, integer or list) columns to be extracted, may be column-names or column index; if is \code{list} each first-level element will be considered as options for one choice}

\item{doExtractCols}{(logical) if default \code{FALSE} only the column indexes will be returned}

\item{callFrom}{(character) allows easier tracking of message(s) produced}

\item{silent}{(logical) suppress messages}
}
\value{
integer-vector (if\code{doExtractCols=FALSE} return depending on input \code{matrix} or \code{data.frame})
}
\description{
This function provides flexible checking if a set of columns may be extracted from a matrix or data.frame 'x'.
If argument \code{extrCol} is list of character vectors, this allows to search among given options, the first matching name for each vector will be identified.
}
\examples{
dFr <- data.frame(a=11:14, b=24:21, cc=LETTERS[1:4], dd=rep(c(TRUE,FALSE),2)) 
extrColsDeX(dFr,c("b","cc","notThere")) 
extrColsDeX(dFr,c("b","cc","notThere"), doExtractCols=TRUE) 
extrColsDeX(dFr, list(c("nn","b","a"), c("cc","a"),"notThere")) 
}
\seealso{
\code{\link[utils]{read.table}}, \code{\link{filterList}}
}
