% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/standardW.R
\name{standardW}
\alias{standardW}
\title{Standardize (scale) data}
\usage{
standardW(mat, byColumn = FALSE, na.rm = TRUE)
}
\arguments{
\item{mat}{(matrix, data.frame or array) data that need to get standardized.}

\item{byColumn}{(logical) if \code{TRUE} the function will be run independently over all columns such as as \code{apply(mat,2,standardW)}}

\item{na.rm}{(logical) if \code{NA}s in the data don't get ignored via this argument, the output will be all \code{NA}}
}
\value{
vector of rescaled data (in dimensions as input)
}
\description{
This functions work similar to \code{\link[base]{scale}}, however, it evaluates the entire input and not column-wise (and independeltly as \code{scale} does). 
With Standarizing we speak of transforming the data to end up with mean=O and sd=1.
Furthermore, in case of 3-dim arrays, this function returns also an object with the same dimensions as the input.
}
\examples{
dat <- matrix(2*round(runif(100),2), ncol=4)
mean(dat); sd(dat)

dat2 <- standardW(dat)
apply(dat2, 2, sd)
summary(dat2)

dat3 <- standardW(dat, byColumn=TRUE)
apply(dat2, 2, sd)
summary(dat2)
mean(dat2); sd(dat2)

}
\seealso{
\code{\link[base]{scale}}
}
