% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmDupl2colMatr.R
\name{rmDupl2colMatr}
\alias{rmDupl2colMatr}
\title{Remove lines of matrix redundant /duplicated for 1st and 2nd column}
\usage{
rmDupl2colMatr(mat, useCol = c(1, 2))
}
\arguments{
\item{mat}{(matrix or data.frame) main input}

\item{useCol}{(integer, length=2) columns to consider/use when looking for duplicated entries}
}
\value{
matrix with duplictaed lines removed
}
\description{
\code{rmDupl2colMatr} removes lines of matrix that are redundant /duplicated for 1st and 2nd column (irrespective of content of their columns).
The first occurance of redundant /duplicated elements is kept.
}
\examples{
mat <- matrix(1:12,ncol=3)
mat[3,1:2] <- mat[1,1:2]
rmDupl2colMatr(mat)
}
\seealso{
\code{\link[base]{unlist}}
}
