% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extrSpcText.R
\name{extrSpcText}
\alias{extrSpcText}
\title{Extract specific text}
\usage{
extrSpcText(
  txt,
  cutFrom = " GN=",
  cutTo = " PE=",
  missingAs = NA,
  exclFromTag = TRUE,
  silent = FALSE,
  callFrom = NULL
)
}
\arguments{
\item{txt}{character vector to be treated}

\item{cutFrom}{(character) text where to start cutting}

\item{cutTo}{(character) text where to stop cutting}

\item{missingAs}{(character) specific content of output at line/location of 'exclLi'}

\item{exclFromTag}{(logical) to exclude text given in 'cutFrom' from result}

\item{silent}{(logical) suppress messages}

\item{callFrom}{(character) allow easier tracking of messages produced}
}
\value{
This function returns a modified character vector
}
\description{
This function extracts/cuts text-fragments out of \code{txt} following specific anchors defined by arguments \code{cutFrom} and \code{cutTo}.
}
\details{
In case \code{cutFrom} is not found \code{missingAs} will be returned.
In case \code{cutTo} is not found, text gets extracted with \code{chaMaxEl} characters.
}
\examples{
extrSpcText(c(" ghjg GN=thisText PE=001"," GN=_ PE=", NA, "abcd"))
extrSpcText(c("ABCDEF.3-6","05g","bc.4-5"), cutFr="\\\\.", cutT="-")
}
\seealso{
\code{\link[base]{substr}}
}
