% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tm_freq.R
\name{tm_freq}
\alias{tm_freq}
\title{Perform a Word or Ngram Frequency Analysis and return a Circular Bar
Plot}
\usage{
tm_freq(data, token = "words", stopwords = NULL, keep = 100, return = "plot")
}
\arguments{
\item{data}{A Meeting Query dataset in the form of a data frame.}

\item{token}{A character vector accepting either \code{"words"} or \code{"ngram"},
determining type of tokenisation to return.}

\item{stopwords}{A character vector OR a single-column data frame labelled
\code{'word'} containing custom stopwords to remove.}

\item{keep}{A numeric vector specifying maximum number of words to keep.}

\item{return}{String specifying what to return. This must be one of the
following strings:
\itemize{
\item \code{"plot"}
\item \code{"table"}
}

See \code{Value} for more information.}
}
\value{
A different output is returned depending on the value passed to the \code{return}
argument:
\itemize{
\item \code{"plot"}: 'ggplot' object. A circular bar plot.
\item \code{"table"}: data frame. A summary table.
}
}
\description{
Generate a circular bar plot with frequency of words / ngrams.
This function is used within \code{meeting_tm_report()}.
}
\details{
This function uses \code{tm_clean()} as the underlying data wrangling function.
There is an option to remove stopwords by passing a data frame into the
\code{stopwords} argument.
}
\examples{
tm_freq(mt_data, token = "words")
tm_freq(mt_data, token = "ngrams")

}
\seealso{
Other Text-mining: 
\code{\link{meeting_tm_report}()},
\code{\link{pairwise_count}()},
\code{\link{subject_validate_report}()},
\code{\link{subject_validate}()},
\code{\link{tm_clean}()},
\code{\link{tm_cooc}()},
\code{\link{tm_wordcloud}()}
}
\concept{Text-mining}
