% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-query-results.R
\name{get_query_results}
\alias{get_query_results}
\alias{next_result}
\alias{next_batch}
\alias{retrieve_all}
\title{Perform a query using the \href{https://www.mediawiki.org/wiki/Special:MyLanguage/API:Main_page}{MediaWiki Action API}}
\usage{
next_result(x)

next_batch(x)

retrieve_all(x)
}
\arguments{
\item{x}{The query. Either a \link{wiki_action_request} or a \link{query_tbl}.}
}
\value{
A \link{query_tbl} containing results of the query. If \code{x} is a
\link{query_tbl}, then the function will return a new data with the new data
appended to it. If \code{x} is a \link{wiki_action_request}, then the returned
\link{query_tbl} will contain the necessary data to supply future calls to
\code{next_result()}, \code{next_batch()} or \code{retrieve_all()}.
}
\description{
\code{next_result()} sends exactly one request to the server.

\code{next_batch()} requests results from the server until data is complete the
latest batch of pages in the result.

\code{retrieve_all()} keeps requesting data until all the pages from the query
have been returned.
}
\details{
It is rare that a query can be fulfilled in a single request to the
server. There are two ways a query can be incomplete. All queries return a
list of pages as their result. The result may be incomplete because not all
the data for each page has been returned. In this case the \emph{batch} is
incomplete. Or the data may be complete for all pages, but there are more
pages available on the server. In this case the query can be \emph{continued}.
Thus the three functions for \code{next_result()}, \code{next_batch()} and
\code{retrieve_all()}.
}
\examples{
# Try out a request using next_result(), then retrieve the rest of the
# results. The clllimt limits the first request to 40 results.
preview <- wiki_action_request() \%>\%
  query_by_title("Steve Wozniak") \%>\%
  query_page_properties("categories", cllimit = 40) \%>\%
  next_result()
preview

all_results <- retrieve_all(preview)
all_results

# tidyr is useful for list-columns.
all_results \%>\%
  tidyr::unnest(cols=c(categories), names_sep = "_")
}
