% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/image_analysis.R
\name{wbt_lee_sigma_filter}
\alias{wbt_lee_sigma_filter}
\title{Lee sigma filter}
\usage{
wbt_lee_sigma_filter(
  input,
  output,
  filterx = 11,
  filtery = 11,
  sigma = 10,
  m = 5,
  wd = NULL,
  verbose_mode = FALSE,
  compress_rasters = FALSE,
  command_only = FALSE
)
}
\arguments{
\item{input}{Input raster file.}

\item{output}{Output raster file.}

\item{filterx}{Size of the filter kernel in the x-direction.}

\item{filtery}{Size of the filter kernel in the y-direction.}

\item{sigma}{Sigma value should be related to the standard deviation of the distribution of image speckle noise.}

\item{m}{M-threshold value the minimum allowable number of pixels within the intensity range.}

\item{wd}{Changes the working directory.}

\item{verbose_mode}{Sets verbose mode. If verbose mode is \code{FALSE}, tools will not print output messages.}

\item{compress_rasters}{Sets the flag used by WhiteboxTools to determine whether to use compression for output rasters.}

\item{command_only}{Return command that would be executed by \code{system()} rather than running tool.}
}
\value{
Returns the tool text outputs.
}
\description{
Performs a Lee (Sigma) smoothing filter on an image.
}
