% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/terrain_analysis.R
\name{wbt_geomorphons}
\alias{wbt_geomorphons}
\title{Geomorphons}
\usage{
wbt_geomorphons(
  dem,
  output,
  search = 50,
  threshold = 0,
  tdist = 0,
  forms = TRUE,
  wd = NULL,
  verbose_mode = FALSE,
  compress_rasters = FALSE,
  command_only = FALSE
)
}
\arguments{
\item{dem}{Input raster DEM file.}

\item{output}{Output raster file.}

\item{search}{Look up distance.}

\item{threshold}{Flatness threshold for the classification function (in degrees).}

\item{tdist}{Distance (in cells) to begin reducing the flatness threshold to avoid problems with pseudo-flat lines-of-sight.}

\item{forms}{Classify geomorphons into 10 common land morphologies, else, output ternary code.}

\item{wd}{Changes the working directory.}

\item{verbose_mode}{Sets verbose mode. If verbose mode is \code{FALSE}, tools will not print output messages.}

\item{compress_rasters}{Sets the flag used by WhiteboxTools to determine whether to use compression for output rasters.}

\item{command_only}{Return command that would be executed by \code{system()} rather than running tool.}
}
\value{
Returns the tool text outputs.
}
\description{
Computes geomorphon patterns.
}
