% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parameter_estimators.R
\name{ml_estimation}
\alias{ml_estimation}
\title{ML Estimation for Two-Parameter Lifetime Distributions}
\usage{
ml_estimation(x, event, distribution = c("weibull", "lognormal",
  "loglogistic"), conf_level = 0.95, details = TRUE)
}
\arguments{
\item{x}{a numeric vector which consists of lifetime data. Lifetime
data could be every characteristic influencing the reliability of a product,
e.g. operating time (days/months in service), mileage (km, miles), load
cycles.}

\item{event}{a vector of binary data (0 or 1) indicating whether unit \emph{i}
is a right censored observation (= 0) or a failure (= 1).}

\item{distribution}{supposed distribution of the random variable. The
value can be \code{"weibull"}, \code{"lognormal"} or \code{"loglogistic"}.
Other distributions have not been implemented yet.}

\item{conf_level}{confidence level of the interval. The default value is
\code{conf_level = 0.95}.}

\item{details}{a logical variable, where the default value is \code{TRUE}.
If \code{FALSE} the output consists of a list that only contains the
estimated parameters. If \code{TRUE} the output is a detailed list with
many more information. See below (\strong{Value}).}
}
\value{
Returns a list with the following components (depending on
\code{details} argument):
  \itemize{
  \item \code{coefficients} : Provided, if \code{distribution} is \code{"weibull"}.
    \eqn{\eta} is the estimated scale and \eqn{\beta} the estimated shape parameter.
  \item \code{confint} : Provided, if \code{distribution} is \code{"weibull"}.
    Confidence interval for \eqn{\eta} and \eqn{\beta}.
  \item \code{loc_sc_coefficients} : Estimated location-scale parameters.
  \item \code{loc_sc_confint} : Confidence interval for location-scale parameters.
  \item \code{loc_sc_vcov} : Estimated Variance-Covariance matrix of the used
    location-scale distribution.
  \item \code{logL} : The log-likelihood value.}
}
\description{
This method estimates the parameters and calculates normal approximation confidence
intervals for a two-parameter lifetime distribution in the frequently used
location-scale parametrization. \code{ml_estimation} uses the
\code{\link{Lifedata.MLE}} function that is defined in the
\emph{SPREDA} package.
For the Weibull the estimates are transformed such that they are in line with
the parametrization provided by the \emph{stats} package like
\code{\link{pweibull}}. The method is applicable for complete and (multiple)
right censored data.
}
\examples{
obs   <- seq(10000, 100000, 10000)
state <- c(0, 1, 1, 0, 0, 0, 1, 0, 1, 0)

mle <- ml_estimation(x = obs, event = state,
                     distribution = "weibull", conf_level = 0.90)

}
