% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/probability_estimators.R
\name{kaplan_method}
\alias{kaplan_method}
\title{Estimation of Failure Probabilities using Kaplan-Meier}
\usage{
kaplan_method(x, event, id = rep("XXXXXX", length(x)))
}
\arguments{
\item{x}{a numeric vector which consists of lifetime data. Lifetime
data could be every characteristic influencing the reliability of a product,
e.g. operating time (days/months in service), mileage (km, miles), load
cycles.}

\item{event}{a vector of binary data (0 or 1) indicating whether unit \emph{i}
is a right censored observation (= 0) or a failure (= 1).}

\item{id}{a character vector for the identification of every unit.}
}
\value{
A data frame containing id, lifetime characteristic, status of the
  unit and the estimated failure probabilty. For right censored observations
  the cells of probability column are filled with NA.
}
\description{
Whereas the non-parametric Kaplan-Meier estimator is used to estimate the
survival function \emph{S(t)} in terms of (multiple) right censored data, the
complement is an estimate of the cumulative distribution function \emph{F(t)}.
One modification is made in contrast to the orginial Kaplan-Meier estimator
(based on \emph{NIST/SEMATECH e-Handbook of Statistical Methods}, 8.2.1.5.):
If the last unit (unit with highest observed lifetime) is a defective unit,
the estimator is adjusted in such a way that the survival estimate for this
unit is not \emph{zero} and therefore the estimate for the failure probability is
not equal to \emph{one}. Otherwise the estimate in this context would be too
pessimisitc.
Since the failure probability estimation in this function is not based on
\emph{Median Ranks}, the Betabinomial confidence intervals cannot be
calculated on the basis of Kaplan-Meier failure probabilities.
}
\examples{
# Example 1
obs   <- seq(10000, 100000, 10000)
state <- c(0, 1, 1, 0, 0, 0, 1, 0, 1, 0)
uic   <- c("3435", "1203", "958X", "XX71", "abcd", "tz46",
           "fl29", "AX23","Uy12", "kl1a")

df_kap <- kaplan_method(x = obs, event = state, id = uic)

# Example 2
 df <- data.frame(obs = c(10000, 10000, 20000, 20000, 30000,
                         30000, 30000, 30000, 40000, 50000,
                         50000, 60000, 70000, 70000, 70000,
                         70000, 80000, 80000, 80000, 80000,
                         90000, 90000, 100000),
                 state = rep(1, 23))

df_kap2 <- kaplan_method(x = df$obs, event = df$state)
}
\references{
\emph{NIST/SEMATECH e-Handbook of Statistical Methods},
\emph{8.2.1.5. Empirical model fitting - distribution free (Kaplan-Meier) approach},
https://www.itl.nist.gov/div898/handbook/apr/section2/apr215.htm, 30/04/2018
}
