# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Computation of Johnson Ranks
#'
#' This function calculates the Johnson ranks which are used to estimate the
#' failure probabilities in case of (multiple) right censored data.
#'
#' @param f a numeric vector indicating the number of failed units for a
#'   specific realization of the lifetime characteristic.
#' @param n_out a numeric vector indicating the number of failed and censored
#'   units that have a shorter realization of lifetime characteristic as unit
#'   \emph{i}.
#' @param n an integer value indicating the sample size.
#'
#' @return A numeric vector containing the computed Johnson ranks.
#' @export
#' @examples
#'   defectives <- c(0, 1, 2, 0, 0, 0, 3, 0, 2, 0)
#'   n_out <- c(0, 2, 4, 8, 9, 11, 12, 16, 20, 22)
#'   n <- 23
#'   johnson_ranks <- calculate_ranks(f = defectives, n_out = n_out, n = n)
calculate_ranks <- function(f, n_out, n) {
    .Call(`_weibulltools_calculate_ranks`, f, n_out, n)
}

