% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chemid.R
\name{ci_query}
\alias{ci_query}
\title{Retrieve information from ChemIDPlus}
\usage{
ci_query(query, from = c("rn", "inchikey"), verbose = getOption("verbose"))
}
\arguments{
\item{query}{character; query string}

\item{from}{character; type of query string, can be one of \code{"rn"} for
CAS registry numbers or \code{"inchikey"}.}

\item{verbose}{logical; should a verbose output be printed on the console?}
}
\value{
A list of 8 entries: name (vector), synonyms (vector), cas (vector),
inchi (vector), inchikey (vector), smiles(vector), toxicity (data.frame),
physprop (data.frame) and source_url.
}
\description{
Retrieve information from ChemIDPlus
\url{https://chem.nlm.nih.gov/chemidplus}
}
\note{
Please respect the Terms and Conditions of the National Library of
Medicine, \url{https://www.nlm.nih.gov/databases/download.html}.
}
\examples{
\dontrun{
# might fail if API is not available
y1 <- ci_query('50-00-0', from = 'rn', match = 'first')
y1[['50-00-0']]$inchikey

# query by inchikey
y2 <- ci_query('WSFSSNUMVMOOMR-UHFFFAOYSA-N', from = 'inchikey')
y2[[1]]$name

# query multiple compounds
comps <- c("50-00-0", "64-17-5")
y3 <- ci_query(comps, from = "rn")

# extract log-P
sapply(y3, function(y){
 if (length(y) == 1 && is.na(y))
   return(NA)
 y$physprop$Value[y$physprop$`Physical Property` == 'log P (octanol-water)']
 })
}
}
