% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dikin_walk.R
\name{dikin_walk}
\alias{dikin_walk}
\title{Dikin Walk}
\usage{
dikin_walk(A, b, x0 = list(), points, r = 1, thin = 1, burn = 0,
  chains = 1)
}
\arguments{
\item{A}{is the lhs of Ax <= b}

\item{b}{is the rhs of Ax <= b}

\item{x0}{is the starting point (a list of points)}

\item{points}{is the number of points we want to sample}

\item{r}{is the radius of the ellipsoid (1 by default)}

\item{thin}{every thin-th point is stored}

\item{burn}{the first burn points are deleted}

\item{chains}{is the number of chains we run}
}
\value{
a list of chains of the sampled points, each chain
        being a matrix object with each column as a point
}
\description{
This function implements the Dikin Walk using the Hessian 
of the Log barrier function. Note that a $r$ of 1 guarantees
that the ellipsoid generated won't leave our polytope $K$ (see
Theorems online)
}
\examples{
\dontrun{
## note that this Ax <= b is different from Ax=b that the 
## user specifies for walkr (see transformation section in vignette) 
dikin_walk(A = A, b = b, x0, points = 100, 
           r = 1thin = 1, burn = 0, chains = 1) 
} 
}
