% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inequalityMeasure.R
\name{Apouey}
\alias{Apouey}
\title{Apouey index}
\usage{
Apouey(
  X,
  W = rep(1, length(X)),
  a = 2/(1 - length(W[!is.na(W) & !is.na(X)])),
  b = length(W[!is.na(W) & !is.na(X)])/(length(W[!is.na(W) & !is.na(X)]) - 1)
)
}
\arguments{
\item{X}{is a data vector (numeric or ordered factor)}

\item{W}{is a vector of weights}

\item{a}{is a positive parameter. See more in details}

\item{b}{is a real parameter. See more in details}
}
\value{
The value of Apouey coefficient.
}
\description{
Computes Apouey inequality measure of a given variable taking into account weights.
}
\details{
Let \eqn{m} be the median category, \eqn{n} will be the number of categories and \eqn{P_i} be the cumulative distribution of \eqn{i}-th category. The following index was proposed by Apouey (2007):
\deqn{I = \alpha(\sum_{i\geq m}^{n}P_{i}-\sum_{i<m}^{n}P_{i}+m-\frac{n}{2}-1)+\beta}
where \eqn{\alpha} and \eqn{\beta} are given parameters with default values \eqn{\alpha=\frac{2}{1-n}} and \eqn{\beta=\frac{n}{n-1}}.
}
\examples{
# Compare weighted and unweighted result
X=1:10
W=1:10
Apouey(X,a=2,b=2)
Apouey(X,W,a=2,b=2)

data(Well_being)
# Apouey index for health assessment with sample weights
X=Well_being$V1
W=Well_being$Weight
Apouey(X,W,a=2,b=2)


}
\references{
Apouey B.: (2007) Measuring health polarization with self-assessed health data, Health Economics 16; 875-894.
}
