% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inequalityMeasure.R
\name{AN_Y}
\alias{AN_Y}
\title{Abul Naga and Yalcin index}
\usage{
AN_Y(X, W = rep(1, length(X)), a = 1, b = 1)
}
\arguments{
\item{X}{is a data vector (numeric or ordered factor)}

\item{W}{is a vector of weights}

\item{a}{is a positive parameter. See more in details}

\item{b}{is a positive parameter. See more in details}
}
\value{
The value of Abul Naga and Yalcin coefficient.
}
\description{
Computes Abul Naga and Yalcin inequality measure of a given variable taking into account weights.
}
\details{
Let \eqn{m} be the median category, \eqn{n} be the number of categories and \eqn{P_{i}} be the cumulative distribution of \eqn{i}-th category.
The following index with respect to the parameters a and b was proposed by Abul Naga and Yalcin (2008):
\deqn{I=\frac{a\sum_{i<m}^{n}P_{i}-b\sum_{i\geq m}^{n}P_{i}+b(n+1-m)}{0.5(a(m-1)+b(n-m))}}
}
\examples{
# Compare weighted and unweighted result
X=1:10
W=1:10
AN_Y(X)
AN_Y(X,W)

data(Well_being)
# Abul Naga and Yalcin index for health assessment with sample weights
X=Well_being$V1
W=Well_being$Weight
AN_Y(X,W)


}
\references{
Ramses H. Abul Naga and Tarik Yalcin: (2008) Inequality Measurement for ordered response health data, Journal of Health Economics 27(6);
}
