% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scanonevar.R
\name{scanonevar}
\alias{scanonevar}
\title{scanonevar}
\usage{
scanonevar(cross, mean.formula = phenotype ~ mean.QTL.add + mean.QTL.dom,
  var.formula = ~var.QTL.add + var.QTL.dom, chrs = qtl::chrnames(cross =
  cross), return.covar.effects = FALSE)
}
\arguments{
\item{cross}{The \code{cross}, built by \pkg{qtl} to be used in mapping}

\item{mean.formula}{The formula to describe the mean of the phenotype.
Keywords are mean.QTL.add and mean.QTL.dom for the additive and dominance
components of the QTL effect on the mean.}

\item{var.formula}{The formula to describe the residual variance of the
phenotype.  Keywords are var.QTL.add and var.QTL.dom for the additive and
dominance components of the QTL effect on residual phenotype variance.}

\item{chrs}{chromosomes to scan}

\item{return.covar.effects}{Should covariate effects estimated at each locus be returned?}
}
\value{
27599
}
\description{
\code{scanonevar} conducts a genome scan in an experimental
cross, accommodating covariate effects in residual variance and identifying
genetic effects on residual variance.
}
\examples{
set.seed(27599)
test.cross <- qtl::sim.cross(map = qtl::sim.map(len = rep(20, 5), n.mar = 5), n.ind = 50)
scanonevar(cross = test.cross)

}
\author{
Robert W. Corty \email{rcorty@gmail.com}
}
