\name{permF.mp}
\alias{permF.mp}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Permutation F-tests for massively parallel linear models}
\description{
Performs permutation F-tests for parallel linear models with a common design matrix.  Currently restricted to testing with the intercept-only model as the null hypothesis.  The permutation method controls the familywise error rate (FWER) at a desired level; see Details.}
\usage{
permF.mp(formula, nperm = 499, alpha = 0.05, report.every = 50)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{formula}{
a formula such as "\code{Y ~ X}", where \code{Y} is an \eqn{n \times V} response matrix and \code{X} is an \eqn{n \times p} design matrix common to all \eqn{V} models.
}
  \item{nperm}{number of permutations.
}
  \item{alpha}{level at which to control the FWER.
}
  \item{report.every}{parameter controlling how often to report the number of permutations performed; by default, every \code{50}.  
}
}
\details{
The observed F-statistics are referred to a permutation distribution of the maximum F-statistic over all V tests.  This is a standard approach to FWER control in neuroimaging (Nichols and Holmes, 2001).}
\value{
\item{maxF.perm}{maximal F-statistics obtained from each of the permuted data sets.}
\item{F.obs}{the observed F-statistics.}
\item{threshold}{critical value obtained from the permutations.}
\item{pvalue}{adjusted (familywise error rate-controlling) p-values.}
}
\references{
Nichols, T. E., and Holmes, A. P. (2001).  Nonparametric permutation tests for functional neuroimaging: a primer with examples.  \emph{Human Brain Mapping}, 15, 1--25.}
\author{
Philip Reiss \email{phil.reiss@nyumc.org} and Lei Huang \email{huangracer@gmail.com}}

\seealso{
\code{\link{F.mp}}
}
\examples{
Y = matrix(rnorm(6000), nrow=20)
X = rnorm(20)
t3 = permF.mp(Y~X)
}

