% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plot_counts_items}
\alias{plot_counts_items}
\title{Output frequencies for multiple variables}
\usage{
plot_counts_items(
  data,
  cols,
  category = NULL,
  ordered = NULL,
  ci = FALSE,
  limits = NULL,
  numbers = NULL,
  title = TRUE,
  labels = TRUE,
  clean = TRUE,
  ...
)
}
\arguments{
\item{data}{A tibble containing item measures.}

\item{cols}{Tidyselect item variables (e.g. starts_with...).}

\item{category}{The value FALSE will force to plot all categories.
A character value will focus a selected category.
When NULL, in case of boolean values, only the TRUE category is plotted.}

\item{ordered}{Values can be nominal (0) or ordered ascending (1) descending (-1).
By default (NULL), the ordering is automatically detected.
An appropriate color scale should be choosen depending on the ordering.
For unordered values, colors from VLKR_FILLDISCRETE are used.
For ordered values, shades of the VLKR_FILLGRADIENT option are used.}

\item{ci}{Whether to plot error bars for 95\% confidence intervals.}

\item{limits}{The scale limits, autoscaled by default.
Set to \code{c(0,100)} to make a 100 \% plot.}

\item{numbers}{The values to print on the bars: "n" (frequency), "p" (percentage) or both.}

\item{title}{If TRUE (default) shows a plot title derived from the column labels.
Disable the title with FALSE or provide a custom title as character value.}

\item{labels}{If TRUE (default) extracts labels from the attributes, see \link{codebook}.}

\item{clean}{Prepare data by \link{data_clean}.}

\item{...}{Placeholder to allow calling the method with unused parameters from \link{plot_counts}.}
}
\value{
A ggplot object.
}
\description{
Output frequencies for multiple variables
}
\examples{
library(volker)
data <- volker::chatgpt

plot_counts_items(data, starts_with("cg_adoption_"))

}
\keyword{internal}
