% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tables.R
\name{tab_counts_one_grouped}
\alias{tab_counts_one_grouped}
\title{Output frequencies cross tabulated with a grouping column}
\usage{
tab_counts_one_grouped(
  data,
  col,
  cross,
  prop = "total",
  percent = TRUE,
  values = c("n", "p"),
  labels = TRUE,
  clean = TRUE,
  ...
)
}
\arguments{
\item{data}{A tibble.}

\item{col}{The column holding factor values.}

\item{cross}{The column holding groups to split.}

\item{prop}{The basis of percent calculation: "total" (the default), "cols", or "rows".}

\item{percent}{Proportions are formatted as percent by default. Set to FALSE to get bare proportions.}

\item{values}{The values to output: n (frequency) or p (percentage) or both (the default).}

\item{labels}{If TRUE (default) extracts labels from the attributes, see \link{codebook}.}

\item{clean}{Prepare data by \link{data_clean}.}

\item{...}{Placeholder to allow calling the method with unused parameters from \link{tab_counts}.}
}
\value{
A volker tibble.
}
\description{
Output frequencies cross tabulated with a grouping column
}
\examples{
library(volker)
data <- volker::chatgpt

tab_counts_one_grouped(data, adopter, sd_gender)

}
\keyword{internal}
